package com.jhscale.security.zuul.application.cache;

import com.jhscale.security.application.client.SecurityApplicationClient;
import com.jhscale.security.component.consensus.model.ApplicationProperties;
import com.jhscale.security.component.cache.CacheComponentConstants;
import com.jhscale.security.component.cache.CacheFlushException;
import com.jhscale.security.component.cache.base.CacheFlushLogic;
import com.jhscale.security.component.cache.base.LocalCache;
import com.jhscale.security.component.consensus.ServerFeignException;
import com.jhscale.security.component.zuul.CacheFlushUtils;
import com.jhscale.security.component.zuul.SecurityZuulConfig;
import com.jhscale.security.zuul.application.service.ApplicationRoutesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author lie_w
 * @title: ApplicationRoutesFlushLogic
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-119:33
 */
@Slf4j
@Component(CacheComponentConstants.COMPONENT_FLAG + "app.routes")
public class ApplicationRoutesFlushLogic implements CacheFlushLogic {

    @Autowired
    private SecurityApplicationClient applicationClient;

    @Autowired
    private SecurityZuulConfig securityZuulConfig;

    @Autowired
    private ApplicationRoutesService applicationRoutesService;

    /**
     * @description: 刷新缓存
     **/
    @Override
    public void flush() throws CacheFlushException {
        applicationRoutesService.clearRoutes();
        try {
            List<ApplicationProperties> applicationProperties = applicationClient.queryAllAppList();
            if (!CollectionUtils.isEmpty(applicationProperties))
                applicationProperties.forEach(app -> {
                    applicationRoutesService.mappingRoute(app);
                    log.debug("Routed Application: {} -> {}", app.getAppId(), app.getZuulPrefix());
                });
            applicationRoutesService.applyRoutes();
        } catch (ServerFeignException e) {
            throw new CacheFlushException("应用中心的应用自动路由失败，未找到统一应用中心服务！");
        }
    }

    /**
     * @param localCache
     * @description: 刷新缓存
     */
    @Async
    @Override
    public void _flush(LocalCache localCache) {
        CacheFlushUtils.flush(this::flush, securityZuulConfig, "应用中心的应用自动路由失败，未找到统一应用中心服务！");
    }

}
