package com.jhscale.security.zuul.application.cache;

import com.jhscale.security.application.client.SecurityApplicationClient;
import com.jhscale.security.application.client.ao.GetAllSpecialAppInfoRes;
import com.jhscale.security.application.client.ao.SpecialApplicationInfo;
import com.jhscale.security.component.cache.CacheComponentConstants;
import com.jhscale.security.component.cache.CacheFlushException;
import com.jhscale.security.component.cache.base.CacheFlushLogic;
import com.jhscale.security.component.cache.base.LocalCache;
import com.jhscale.security.component.zuul.CacheFlushUtils;
import com.jhscale.security.component.zuul.SecurityZuulConfig;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lie_w
 * @title: SpecialApplicationCacheFlushLogic
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-119:41
 */
@Slf4j
@Component(CacheComponentConstants.COMPONENT_FLAG + "app.special")
public class SpecialApplicationCacheFlushLogic implements CacheFlushLogic {

    private LocalCache localCache;

    @Autowired
    private SecurityApplicationClient applicationClient;

    @Autowired
    private SecurityZuulConfig securityZuulConfig;

    /**
     * @description: 刷新缓存
     **/
    @Override
    public void flush() throws CacheFlushException {
        try {
            GetAllSpecialAppInfoRes allSpecialAppInfoRes = applicationClient.getAllSpecialAppInfo();
            allSpecialAppInfoRes.getAppInfo().forEach((k, v) -> {
                ConcurrentHashMap<String, SpecialApplicationInfo> channelInfoConcurrentHashMap = new ConcurrentHashMap<>((int) (v.size() / .75));
                v.forEach((ik, iv) -> {
                    channelInfoConcurrentHashMap.put(ik, iv);
                    log.debug("Cached SpecialApplication: {} -> {} -> {}", k, ik, iv);
                });
                localCache.cache(k, channelInfoConcurrentHashMap);
            });
        } catch (Exception e) {
            log.warn("没有SpecialApplication信息被缓存，可能是未找到统一应用中心服务，请看：{}", e.getMessage());
        }
    }

    /**
     * @param localCache
     * @description: 刷新缓存
     */
    @Async
    @Override
    public void _flush(LocalCache localCache) {
        this.localCache = localCache;
        CacheFlushUtils.flush(this::flush, securityZuulConfig, "没有SpecialApplication信息被缓存，可能是未找到统一应用中心服务");
    }
}
