package com.jhscale.security.zuul.application.component;

import com.jhscale.security.component.zuul.ZuulForwardUrlProvider;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.stereotype.Component;

/**
 * @author lie_w
 * @title: ApplicationManagerProvider
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-119:47
 */
@Data
@Component("manager.application")
public class ApplicationManagerProvider implements ZuulForwardUrlProvider {

    @Value("${jhscale.security.service-id.application:server-application}")
    private String application;

    @Autowired
    private LoadBalancerClient loadBalancer;

    /**
     * 获取Manager Address
     *
     * @return
     */
    @Override
    public String url() {
        return getManagerUrlByServiceId(loadBalancer, application);
    }

    @Override
    public int order() {
        return ZuulForwardUrlProvider.APPLICATION_FORWARD;
    }
}
