package com.jhscale.security.zuul.application.route;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.SimpleRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lie_w
 * @title: ApplicationRouteLocator
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-118:19
 */
@Component
public class ApplicationRouteLocator extends SimpleRouteLocator implements RefreshableRouteLocator {
    @Autowired
    public ApplicationRouteLocator(ServerProperties serverProperties, ZuulProperties zuulProperties) {
        super(serverProperties.getServlet().getContextPath(), zuulProperties);
    }

    private Map<String, ZuulProperties.ZuulRoute> localRoutes = new ConcurrentHashMap<>(32);

    @Override
    protected Map<String, ZuulProperties.ZuulRoute> locateRoutes() {
        return localRoutes;
    }

    @Override
    public void refresh() {
        doRefresh();
    }

    public void remove(String path) {
        this.localRoutes.remove(path);
    }

    public void put(String path, ZuulProperties.ZuulRoute zuulRoute) {
        this.localRoutes.put(path, zuulRoute);
    }

    public void clear() {
        this.localRoutes.clear();
    }
}
