package com.jhscale.security.zuul.application.service.impl;

import com.jhscale.security.component.consensus.model.ApplicationProperties;
import com.jhscale.security.component.zuul.ZuulUtils;
import com.jhscale.security.zuul.application.route.ApplicationRouteLocator;
import com.jhscale.security.zuul.application.service.ApplicationRoutesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/**
 * @author lie_w
 * @title: ApplicationRoutesServiceImpl
 * @projectName Rely-On-Security
 * @description: TODO
 * @date 2020-11-119:35
 */
@Slf4j
@Service
public class ApplicationRoutesServiceImpl implements ApplicationRoutesService {

    @Autowired
    private ApplicationEventPublisher publisher;

    @Autowired
    private ApplicationRouteLocator routeLocator;

    /**
     * @param applicationProperties
     * @description: 添加路由
     */
    @Override
    public void addRoute(ApplicationProperties applicationProperties) {
        mappingRoute(applicationProperties);
        applyRoutes();
    }

    /**
     * @param content
     * @description: 删除路由
     */
    @Override
    public void deleteRoute(String content) {
        routeLocator.remove(content);
        publisher.publishEvent(new RoutesRefreshedEvent(routeLocator));
    }

    /**
     * @param properties
     * @description: 映射路由
     */
    @Override
    public void mappingRoute(ApplicationProperties properties) {
        ZuulProperties.ZuulRoute zuulRoute = ZuulUtils.zuulRoute(properties);
        routeLocator.put(zuulRoute.getPath(), zuulRoute);
    }

    /**
     * @description: 应用所有路由
     **/
    @Override
    public void applyRoutes() {
        publisher.publishEvent(new RoutesRefreshedEvent(routeLocator));
    }

    /**
     * @description: 清空所有路由
     **/
    @Override
    public void clearRoutes() {
        routeLocator.clear();
        publisher.publishEvent(new RoutesRefreshedEvent(routeLocator));
    }
}
