/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.security.zuul.signature.filter;

import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.GeneralInternation;
import com.jhscale.common.exception.SignatureException;
import com.jhscale.common.model.http.JRequest;
import com.jhscale.common.utils.MD5Utils;
import com.jhscale.security.component.consensus.exp.ConsenseException;
import com.jhscale.security.component.consensus.exp.ConsenseInternational;
import com.jhscale.security.component.consensus.utils.HeadUtils;
import com.jhscale.security.component.consensus.utils.HttpUtils;
import com.jhscale.security.component.zuul.FilterUtils;
import com.jhscale.security.component.zuul.ZuulComponentConstants;
import com.jhscale.security.zuul.signature.config.SignatureConfig;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import com.ysscale.framework.utils.JSONUtils;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SignatureFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(SignatureFilter.class);
    @Autowired
    private SignatureConfig signatureConfig;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return ZuulComponentConstants.SIGNATURE_ORDER_FILTER_ORDER;
    }

    public boolean shouldFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        if (Objects.nonNull(ctx.get((Object)"hard-break"))) {
            return false;
        }
        return this.signatureConfig.isOpen() && Objects.nonNull(ctx.get((Object)"X-Equipment-Key"));
    }

    public Object run() throws ZuulException {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        String key = RequestContext.getCurrentContext().get((Object)"X-Equipment-Key").toString();
        log.debug("\u5f00\u59cb\u7b7e\u540d\u9a8c\u8bc1 Key:{}", (Object)key);
        String method = request.getMethod();
        try {
            if ("GET".equalsIgnoreCase(method)) {
                String secret = HeadUtils.getHeadContent((HttpServletRequest)request, (String)"X-Equipment-Secret");
                if (StringUtils.isBlank((CharSequence)secret)) {
                    throw new ConsenseException(450, ConsenseInternational.\u8bbe\u5907\u5bc6\u94a5\u4e0d\u5b58\u5728);
                }
                if (!secret.equals(key)) {
                    throw new ConsenseException(450, ConsenseInternational.\u8bbe\u5907\u5bc6\u94a5\u65e0\u6548);
                }
            } else {
                String data = HttpUtils.readData((HttpServletRequest)request);
                log.debug("\u8bf7\u6c42\u65b9\u5f0f\uff1a{}\uff0c\u53c2\u6570\u5185\u5bb9\uff1a{}", (Object)method, (Object)data);
                if (StringUtils.isBlank((CharSequence)data)) {
                    throw new ConsenseException(450, ConsenseInternational.\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b58\u5728);
                }
                JRequest jsonRequest = (JRequest)JSONUtils.jsonToPojo((String)data, JRequest.class);
                if (Objects.isNull(jsonRequest)) {
                    throw new ConsenseException(450, ConsenseInternational.\u8bf7\u6c42\u53c2\u6570\u65e0\u6548);
                }
                jsonRequest.checkPackage(key, this.signatureConfig.getSingnatureInvalidTime());
                String sourceSignature = MD5Utils.bulidSourceSignature((Map)((Map)JSONUtils.jsonToPojo((String)data, Map.class)), (String)key);
                log.debug("\u670d\u52a1\u5668\u89e3\u6790\u7b7e\u540d\u6e90\u7801\uff1a{}", (Object)sourceSignature);
                String sign = MD5Utils.bulidMD5Signature((String)sourceSignature);
                log.debug("\u670d\u52a1\u5668\u8fd8\u539fMD5\u7b7e\u540d\uff1a{}\uff0c\u8bf7\u6c42\u7b7e\u540d\uff1a{}", (Object)sign, (Object)jsonRequest.getSign());
                if (!jsonRequest.getSign().equals(sign)) {
                    throw new SignatureException(GeneralInternation.\u7b7e\u540d\u65e0\u6548);
                }
            }
        }
        catch (ConsenseException e) {
            log.error("\u7b7e\u540d\u53c2\u6570\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            FilterUtils.fail((Integer)e.getResponseCode(), (RequestContext)ctx, (GeneralException)e);
        }
        catch (SignatureException e) {
            log.error("\u7b7e\u540d\u68c0\u67e5\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            FilterUtils.fail((Integer)450, (RequestContext)ctx, (GeneralException)e);
        }
        return null;
    }
}

