/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale;

import com.jhscale.config.RestTemplateConfig;
import com.jhscale.wxaccount.client.WxaccountsClient;
import com.jhscale.wxaccount.config.WxESAccountConfig;
import com.jhscale.wxaccount.config.WxOAAccountConfig;
import com.ysscale.framework.domain.WxAccessToken;
import com.ysscale.sevice.AccountCertUtilsService;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@ComponentScan
@Configuration
public class AccountsConfiguration {
    @Primary
    @Bean(value={"esaccountsClient"})
    public WxaccountsClient esaccountsClient(@Autowired WxESAccountConfig accountConfig, @Autowired RestTemplateConfig restTemplateConfig, @Autowired AccountCertUtilsService accountCertUtilsService) {
        return new WxaccountsClient(accountConfig, restTemplateConfig, accountCertUtilsService);
    }

    @Bean(value={"oaaccountsClient"})
    public WxaccountsClient oaaccountsClient(@Autowired WxOAAccountConfig accountConfig, @Autowired RestTemplateConfig restTemplateConfig, @Autowired AccountCertUtilsService accountCertUtilsService) {
        return new WxaccountsClient(accountConfig, restTemplateConfig, accountCertUtilsService);
    }

    @Bean
    @ConditionalOnMissingBean
    public AccountCertUtilsService accountCertUtilsService() {
        return new AccountCertUtilsService(){
            Map<String, WxAccessToken> accessTokenConcurrentHashMap = new ConcurrentHashMap<String, WxAccessToken>();

            public WxAccessToken getAccesstoken(String ... dirSign) {
                if (dirSign == null || dirSign.length == 0) {
                    return null;
                }
                String key = "";
                for (String sign : dirSign) {
                    key = key + sign;
                }
                WxAccessToken wxAccessToken = this.accessTokenConcurrentHashMap.get(key);
                if (Objects.isNull(wxAccessToken)) {
                    return null;
                }
                int time = (int)((System.currentTimeMillis() - wxAccessToken.getCreate_time().getTime()) / 1000L);
                if (time > wxAccessToken.getExpires_in()) {
                    return null;
                }
                return wxAccessToken;
            }

            public void saveAccesstoken(WxAccessToken accesstoken, String ... dirSign) {
                if (dirSign == null || dirSign.length == 0 || Objects.isNull(accesstoken)) {
                    return;
                }
                String key = "";
                for (String sign : dirSign) {
                    key = key + sign;
                }
                this.accessTokenConcurrentHashMap.put(key, accesstoken);
            }

            public void removeAccesstoken(String ... dirSign) {
                if (dirSign == null || dirSign.length == 0) {
                    return;
                }
                String key = "";
                for (String sign : dirSign) {
                    key = key + sign;
                }
                this.accessTokenConcurrentHashMap.remove(key);
            }
        };
    }
}

