/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.wxaccount.accept.controller;

import com.jhscale.wxaccount.accept.service.WxAccountsService;
import com.jhscale.wxaccount.accept.vo.AccessTokeRequest;
import com.jhscale.wxaccount.accept.vo.AuthCheckRequest;
import com.jhscale.wxaccount.accept.vo.GetAccountSignatureRequest;
import com.jhscale.wxaccount.accept.vo.RefreshTokenRequest;
import com.jhscale.wxaccount.accept.vo.UserinfoByCodeResponse;
import com.jhscale.wxaccount.accept.vo.UserinfoRequest;
import com.jhscale.wxaccount.jsapi.model.SignatureRes;
import com.jhscale.wxaccount.model.WxaccountsRes;
import com.jhscale.wxaccount.web.model.SNSOauth2AccessTokenRes;
import com.jhscale.wxaccount.web.model.SNSOauth2RefreshTokenRes;
import com.jhscale.wxaccount.web.model.SNSUserinfoRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@Api(description="\u5fae\u4fe1\u8c03\u5ea6\u63a5\u53e3")
public class WxAccountsController {
    @Autowired
    private WxAccountsService accountsService;

    @ApiOperation(value="/accept", notes="\u63a5\u6536\u516c\u4f17\u53f7\u4fe1\u606f")
    @RequestMapping(value={"/accept/{sign}"}, method={RequestMethod.POST, RequestMethod.GET})
    public String access(@PathVariable(value="sign") String sign, @RequestParam(value="msg_signature", required=false) String msgSignature, @RequestParam(value="signature", required=false) String signature, @RequestParam(value="timestamp", required=false) String timestamp, @RequestParam(value="nonce", required=false) String nonce, @RequestParam(value="echostr", required=false) String echostr, HttpServletRequest request) {
        return this.accountsService.accept(sign, msgSignature, signature, timestamp, nonce, echostr, request);
    }

    @ApiOperation(value="/userinfo_code", notes="code\u6362\u53d6\u7f51\u9875\u6388\u6743access_token\u540e \u62c9\u53d6\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/userinfo_code"})
    public UserinfoByCodeResponse userinfoCode(@RequestBody AccessTokeRequest request) {
        return this.accountsService.userinfoCode(request);
    }

    @ApiOperation(value="/access_token", notes="code\u6362\u53d6\u7f51\u9875\u6388\u6743access_token")
    @PostMapping(value={"/access_token"})
    public SNSOauth2AccessTokenRes accessToken(@RequestBody AccessTokeRequest request) {
        return this.accountsService.accessToken(request);
    }

    @ApiOperation(value="/refresh_token", notes="\u5237\u65b0access_token\uff08\u5982\u679c\u9700\u8981\uff09")
    @PostMapping(value={"/refresh_token"})
    public SNSOauth2RefreshTokenRes refreshToken(@RequestBody RefreshTokenRequest request) {
        return this.accountsService.refreshToken(request);
    }

    @ApiOperation(value="/userinfo", notes="\u62c9\u53d6\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/userinfo"})
    public SNSUserinfoRes userinfo(@RequestBody UserinfoRequest request) {
        return this.accountsService.userinfo(request);
    }

    @ApiOperation(value="/auth_check", notes="\u68c0\u9a8c\u6388\u6743\u51ed\u8bc1\uff08access_token\uff09\u662f\u5426\u6709\u6548")
    @PostMapping(value={"/auth_check"})
    public WxaccountsRes authCheck(@RequestBody AuthCheckRequest request) {
        return this.accountsService.authCheck(request);
    }

    @ApiOperation(value="/auth_signature", notes="\u83b7\u53d6\u516c\u4f17\u53f7\u6388\u6743\u7b7e\u540d")
    @PostMapping(value={"/auth_signature"})
    public SignatureRes authSignature(@RequestBody GetAccountSignatureRequest request) {
        return this.accountsService.authSignature(request);
    }
}

