/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.wxaccount.accept.service.impl;

import com.jhscale.wxaccount.accept.service.WxAcceptService;
import com.jhscale.wxaccount.accept.service.WxAccountsService;
import com.jhscale.wxaccount.accept.vo.AccessTokeRequest;
import com.jhscale.wxaccount.accept.vo.AuthCheckRequest;
import com.jhscale.wxaccount.accept.vo.GetAccountSignatureRequest;
import com.jhscale.wxaccount.accept.vo.RefreshTokenRequest;
import com.jhscale.wxaccount.accept.vo.UserinfoByCodeResponse;
import com.jhscale.wxaccount.accept.vo.UserinfoRequest;
import com.jhscale.wxaccount.client.WxaccountsClient;
import com.jhscale.wxaccount.jsapi.model.SignatureReq;
import com.jhscale.wxaccount.jsapi.model.SignatureRes;
import com.jhscale.wxaccount.model.WxaccountsAccept;
import com.jhscale.wxaccount.model.WxaccountsRes;
import com.jhscale.wxaccount.model.WxaccountsResponse;
import com.jhscale.wxaccount.web.model.SNSAuthReq;
import com.jhscale.wxaccount.web.model.SNSOauth2AccessTokenReq;
import com.jhscale.wxaccount.web.model.SNSOauth2AccessTokenRes;
import com.jhscale.wxaccount.web.model.SNSOauth2RefreshTokenReq;
import com.jhscale.wxaccount.web.model.SNSOauth2RefreshTokenRes;
import com.jhscale.wxaccount.web.model.SNSUserinfoReq;
import com.jhscale.wxaccount.web.model.SNSUserinfoRes;
import com.ysscale.framework.utils.HttpKit;
import com.ysscale.framework.utils.JSONUtils;
import com.ysscale.framework.utils.MapXml;
import com.ysscale.framework.utils.SpringUtil;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class WxAccountsServiceImpl
implements WxAccountsService {
    private static final Logger log = LoggerFactory.getLogger(WxAccountsServiceImpl.class);
    private Map<String, WxaccountsClient> wxaccountsClientMap;
    @Autowired
    @Qualifier(value="WX-DEFAULT")
    private WxAcceptService defaultAcceptService;

    @Override
    public String accept(String sign, String msgSignature, String signature, String timestamp, String nonce, String echostr, HttpServletRequest request) {
        String body = HttpKit.readData((HttpServletRequest)request);
        log.debug("\u63a5\u53d7\u5230\u5fae\u4fe1\u8f6c\u53d1\u4fe1\u606f\u5982\u4e0b\uff1a\nmsgSignature\uff1a{}\uff0c\nsignature\uff1a{}\uff0c\ntimestamp\uff1a{}\uff0c\nnonce\uff1a{}\uff0c\nechostr\uff1a{}\uff0c\nbody\uff1a{}", new Object[]{msgSignature, signature, timestamp, nonce, echostr, MapXml.parseXml((String)body)});
        if (StringUtils.isBlank((CharSequence)body)) {
            return echostr;
        }
        WxaccountsClient client = this.wxaccountsClient(sign);
        if (Objects.isNull(client)) {
            return "SUCCESS";
        }
        WxaccountsAccept accept = client.decrypt(sign, msgSignature, timestamp, nonce, body);
        log.debug("\u5fae\u4fe1\u8f6c\u53d1\u4fe1\u606f\u5185\u5bb9\uff1a{}", (Object)JSONUtils.objectJsonParse((Object)accept));
        if (Objects.isNull(accept)) {
            return "SUCCESS";
        }
        Object handler = null;
        try {
            handler = SpringUtil.getBean((String)accept.listenServiceName());
        }
        catch (Exception e) {
            log.error("Not Found Accept [{}]", (Object)accept.getMsgType());
        }
        WxAcceptService accessEventService = Objects.nonNull(handler) ? (WxAcceptService)handler : this.defaultAcceptService;
        WxaccountsResponse response = accessEventService.accept(accept);
        if (Objects.isNull(response)) {
            response = this.defaultAcceptService.accept(accept);
        }
        response.addResponse(accept);
        log.debug("\u5e94\u7b54\u5fae\u4fe1\u4fe1\u606f\u5185\u5bb9\uff1a{}", (Object)JSONUtils.objectJsonParse((Object)response));
        return client.encryt(response, timestamp, nonce);
    }

    @Override
    public UserinfoByCodeResponse userinfoCode(AccessTokeRequest request) {
        SNSOauth2AccessTokenReq getOpenidByCodeReq = new SNSOauth2AccessTokenReq();
        getOpenidByCodeReq.setCode(request.getCode());
        SNSOauth2AccessTokenRes accessTokenRes = this.wxaccountsClient(request.getSign()).execute(getOpenidByCodeReq);
        UserinfoByCodeResponse response = new UserinfoByCodeResponse();
        if (Objects.nonNull(accessTokenRes)) {
            if (accessTokenRes.checkResult()) {
                response.setAccessTokenRes(accessTokenRes);
                SNSUserinfoReq snsUserinfoReq = new SNSUserinfoReq();
                snsUserinfoReq.setOpenid(accessTokenRes.getOpenid());
                snsUserinfoReq.setAccess_token(accessTokenRes.getAccess_token());
                SNSUserinfoRes userinfoRes = this.wxaccountsClient(request.getSign()).execute(snsUserinfoReq);
                if (Objects.nonNull(userinfoRes)) {
                    response.setErrcode(userinfoRes.getErrcode());
                    response.setErrmsg(userinfoRes.getErrmsg());
                    if (accessTokenRes.checkResult()) {
                        response.setUserinfoRes(userinfoRes);
                    }
                } else {
                    response.setErrcode(40003);
                    response.setErrmsg("invalid openid");
                }
            } else {
                response = (UserinfoByCodeResponse)((Object)JSONUtils.beanToBean((Object)accessTokenRes, UserinfoByCodeResponse.class));
            }
        } else {
            response.setErrcode(40029);
            response.setErrmsg("invalid code");
        }
        return response;
    }

    @Override
    public SNSOauth2AccessTokenRes accessToken(AccessTokeRequest request) {
        SNSOauth2AccessTokenReq getOpenidByCodeReq = new SNSOauth2AccessTokenReq();
        getOpenidByCodeReq.setCode(request.getCode());
        return this.wxaccountsClient(request.getSign()).execute(getOpenidByCodeReq);
    }

    @Override
    public SNSOauth2RefreshTokenRes refreshToken(RefreshTokenRequest request) {
        SNSOauth2RefreshTokenReq oauth2RefreshTokenReq = new SNSOauth2RefreshTokenReq();
        oauth2RefreshTokenReq.setRefresh_token(request.getRefresh_token());
        return this.wxaccountsClient(request.getSign()).execute(oauth2RefreshTokenReq);
    }

    @Override
    public SNSUserinfoRes userinfo(UserinfoRequest request) {
        SNSUserinfoReq snsUserinfoReq = new SNSUserinfoReq();
        snsUserinfoReq.setOpenid(request.getOpenid());
        snsUserinfoReq.setAccess_token(request.getAccess_token());
        return this.wxaccountsClient(request.getSign()).execute(snsUserinfoReq);
    }

    @Override
    public WxaccountsRes authCheck(AuthCheckRequest request) {
        SNSAuthReq authReq = new SNSAuthReq();
        authReq.setOpenid(request.getOpenid());
        authReq.setAccess_token(request.getAccess_token());
        return this.wxaccountsClient(request.getSign()).execute(authReq);
    }

    @Override
    public WxaccountsClient wxaccountsClient(String sign) {
        if (this.wxaccountsClientMap == null || this.wxaccountsClientMap.isEmpty()) {
            this.wxaccountsClientMap = SpringUtil.getApplicationContext().getBeansOfType(WxaccountsClient.class);
        }
        if (this.wxaccountsClientMap == null || this.wxaccountsClientMap.isEmpty()) {
            return null;
        }
        for (WxaccountsClient wxaccountsClient : this.wxaccountsClientMap.values()) {
            if (!wxaccountsClient.checksign(sign)) continue;
            return wxaccountsClient;
        }
        return (WxaccountsClient)SpringUtil.getBean(WxaccountsClient.class);
    }

    @Override
    public SignatureRes authSignature(GetAccountSignatureRequest request) {
        WxaccountsClient wxaccountsClient = this.wxaccountsClient(request.getSign());
        SignatureReq signatureReq = new SignatureReq();
        signatureReq.setUrl(request.getUrl());
        return wxaccountsClient.getSignature(signatureReq);
    }
}

