/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.wxaccount.client;

import com.jhscale.config.RestTemplateConfig;
import com.jhscale.wxaccount.WxaccountsService;
import com.jhscale.wxaccount.config.WxaccountsConfig;
import com.jhscale.wxaccount.entity.WxAccept;
import com.jhscale.wxaccount.jsapi.model.GetticketReq;
import com.jhscale.wxaccount.jsapi.model.GetticketRes;
import com.jhscale.wxaccount.jsapi.model.SignatureReq;
import com.jhscale.wxaccount.jsapi.model.SignatureRes;
import com.jhscale.wxaccount.model.WxaccountsAccept;
import com.jhscale.wxaccount.model.WxaccountsReq;
import com.jhscale.wxaccount.model.WxaccountsRes;
import com.jhscale.wxaccount.model.WxaccountsResponse;
import com.jhscale.wxaccount.send.WxAccessTokenReq;
import com.jhscale.wxaccount.send.WxAccessTokenRes;
import com.jhscale.wxaccount.utils.Signature;
import com.jhscale.wxaccount.utils.XmlMapUtil;
import com.jhscale.wxaccount.utils.aes.AesException;
import com.jhscale.wxaccount.utils.aes.WXBizMsgCrypt;
import com.ysscale.framework.domain.WxAccessToken;
import com.ysscale.framework.utils.JSONUtils;
import com.ysscale.framework.utils.MapXml;
import com.ysscale.sevice.AccountCertUtilsService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;

public class WxaccountsClient
implements WxaccountsService {
    private static final Logger log = LoggerFactory.getLogger(WxaccountsClient.class);
    private WxaccountsConfig wxaccountsConfig;
    private RestTemplate restTemplate;
    private WXBizMsgCrypt wxBizMsgCrypt;
    private AccountCertUtilsService accountCertUtilsService;

    public WxaccountsClient(WxaccountsConfig wxaccountsConfig, RestTemplateConfig restTemplateConfig, AccountCertUtilsService accountCertUtilsService) {
        this.wxaccountsConfig = wxaccountsConfig;
        this.restTemplate = this.bulidRestemplate(restTemplateConfig);
        this.accountCertUtilsService = accountCertUtilsService;
        try {
            this.wxBizMsgCrypt = new WXBizMsgCrypt(wxaccountsConfig.getToken(), wxaccountsConfig.getEncodingAesKey(), wxaccountsConfig.getAppId());
        }
        catch (AesException e) {
            log.error("WxAccountsClient init error\uff1a{}", (Object)e.getMessage());
        }
    }

    @Override
    public <T extends WxaccountsRes> T execute(WxaccountsReq<T> request) {
        return this.execute(request, request.resClass());
    }

    @Override
    public <T extends WxaccountsRes> T execute(WxaccountsReq<T> request, Class<T> clazz) {
        String url = request.getUrl(this.wxaccountsConfig.getChannel());
        log.debug("Public accounts  url: {}, request: {}", (Object)url, (Object)JSONUtils.objectJsonParseWithoutNull(request));
        try {
            List<String> params = request.params(this.wxaccountsConfig);
            List<Object> arrayList = new ArrayList<String>();
            if (request.assenbleAccessToken()) {
                arrayList.add(this.accesstoken().getAccess_token());
                if (!CollectionUtils.isEmpty(params)) {
                    for (String param : params) {
                        arrayList.add(param);
                    }
                }
            } else {
                arrayList = params;
            }
            Object[] array = arrayList.toArray(new String[0]);
            WxaccountsRes result = null;
            result = RequestMethod.GET.equals((Object)request.method()) ? (WxaccountsRes)this.restTemplate.getForObject(url, clazz, array) : (WxaccountsRes)this.restTemplate.postForObject(url, request, clazz, array);
            log.debug("Public accounts response: {}", (Object)JSONUtils.objectJsonParseWithoutNull((Object)result));
            return (T)result;
        }
        catch (Exception e) {
            log.error("\u516c\u4f17\u53f7\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Override
    public WxAccessToken accesstoken() {
        WxAccessToken accesstoken = this.accountCertUtilsService.getAccesstoken(new String[]{"WX-MINI-ACCESS-TOKEN", this.wxaccountsConfig.getSign()});
        if (Objects.isNull(accesstoken)) {
            WxAccessTokenRes response = (WxAccessTokenRes)this.restTemplate.getForObject(new WxAccessTokenReq().getUrl(this.wxaccountsConfig.getChannel()), WxAccessTokenRes.class, new Object[]{"client_credential", this.wxaccountsConfig.getAppId(), this.wxaccountsConfig.getAppSecret()});
            log.debug("HTTP \u516c\u4f17\u53f7\u8bc1\u4e66 \u8bf7\u6c42\u54cd\u5e94\u4fe1\u606f\uff1a{}", (Object)JSONUtils.objectToJson((Object)response));
            if (Objects.nonNull(response)) {
                accesstoken = (WxAccessToken)JSONUtils.beanToBean((Object)response, WxAccessToken.class);
                accesstoken.setCreate_time(new Date());
                this.accountCertUtilsService.saveAccesstoken(accesstoken, new String[]{"WX-MINI-ACCESS-TOKEN", this.wxaccountsConfig.getSign()});
            }
        }
        log.debug("\u516c\u4f17\u53f7\u8bc1\u4e66 \u4fe1\u606f\uff1a{}", (Object)JSONUtils.objectToJson((Object)accesstoken));
        return accesstoken;
    }

    @Override
    public WxAccessToken getTicket() {
        WxAccessToken accesstoken = this.accountCertUtilsService.getAccesstoken(new String[]{"WX-MINI-TOCKET", this.wxaccountsConfig.getSign()});
        if (Objects.isNull(accesstoken)) {
            GetticketRes response = (GetticketRes)this.restTemplate.getForObject(new GetticketReq().getUrl(this.wxaccountsConfig.getChannel()), GetticketRes.class, new Object[]{this.accesstoken().getAccess_token()});
            log.debug("HTTP \u516c\u4f17\u53f7Ticket \u8bf7\u6c42\u54cd\u5e94\u4fe1\u606f\uff1a{}", (Object)JSONUtils.objectToJson((Object)response));
            if (Objects.nonNull(response)) {
                accesstoken = new WxAccessToken();
                accesstoken.setAccess_token(response.getTicket());
                accesstoken.setExpires_in(response.getExpires_in());
                accesstoken.setCreate_time(new Date());
                this.accountCertUtilsService.saveAccesstoken(accesstoken, new String[]{"WX-MINI-TOCKET", this.wxaccountsConfig.getSign()});
            }
        }
        log.debug("\u516c\u4f17\u53f7Ticket \u4fe1\u606f\uff1a{}", (Object)JSONUtils.objectToJson((Object)accesstoken));
        return accesstoken;
    }

    @Override
    public SignatureRes getSignature(SignatureReq signatureReq) {
        signatureReq.setJsapi_ticket(this.getTicket().getAccess_token());
        SignatureRes signatureRes = new SignatureRes();
        signatureRes.setAppId(this.wxaccountsConfig.getAppId());
        signatureRes.setNonceStr(signatureReq.getNoncestr());
        signatureRes.setTimestamp(signatureReq.getTimestamp());
        signatureRes.setSignature(Signature.getSign(signatureReq.toMap(new String[0])));
        return signatureRes;
    }

    @Override
    public WxaccountsAccept decrypt(String sign, String msgSignature, String timestamp, String nonce, String xmlBody) {
        try {
            Map<String, String> map;
            WxAccept accept;
            String msg = this.wxBizMsgCrypt.decryptMsg(msgSignature, timestamp, nonce, xmlBody);
            log.debug("\u5fae\u4fe1\u8f6c\u53d1\u89e3\u5bc6\u540eXML\u4fe1\u606f\uff1a{}", (Object)MapXml.parseXml((String)msg));
            if (StringUtils.isNotBlank((CharSequence)msg) && Objects.nonNull(accept = XmlMapUtil.mapToBean(map = XmlMapUtil.xmlToMap(msg, "utf-8"), WxAccept.class))) {
                WxaccountsAccept wxaccountsAccept = XmlMapUtil.mapToBean(map, accept.accept());
                wxaccountsAccept.setSign(sign);
                return wxaccountsAccept;
            }
        }
        catch (AesException e) {
            log.error("\u5fae\u4fe1\u6d88\u606f\u63a5\u53d7\u89e3\u5bc6\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }

    @Override
    public String encryt(WxaccountsResponse response, String timestamp, String nonce) {
        try {
            String result = response.result();
            log.debug("\u5fae\u4fe1\u5e94\u7b54\u52a0\u5bc6\u524dXML\u4fe1\u606f\uff1a{}", (Object)MapXml.parseXml((String)result));
            String encryt = this.wxBizMsgCrypt.encryptMsg(result, timestamp, nonce);
            log.debug("\u5fae\u4fe1\u5e94\u7b54\u52a0\u5bc6\u540eXML\u4fe1\u606f\uff1a{}", (Object)MapXml.parseXml((String)encryt));
            return encryt;
        }
        catch (AesException e) {
            log.error("\u5fae\u4fe1\u6d88\u606f\u52a0\u5bc6\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
            return "SUCCESS";
        }
    }

    @Override
    public boolean checksign(String sign) {
        return this.wxaccountsConfig.getSign().equalsIgnoreCase(sign);
    }

    private RestTemplate bulidRestemplate(RestTemplateConfig restTemplateConfig) {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(restTemplateConfig.getRetryCount(), true));
        clientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy());
        RegistryBuilder registryBuilder = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
        if (StringUtils.isNotBlank((CharSequence)this.wxaccountsConfig.getCertLocalPath())) {
            try {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                InputStream fileInputStream = new ClassPathResource(this.wxaccountsConfig.getCertLocalPath() + File.separator + "apiclient_cert.p12").getInputStream();
                keyStore.load(fileInputStream, this.wxaccountsConfig.getCertPassword().toCharArray());
                SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(keyStore, this.wxaccountsConfig.getCertPassword().toCharArray()).build();
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                registryBuilder.register("https", (Object)sslConnectionSocketFactory);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                log.error("\u5fae\u4fe1\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a{}", (Object)e.getMessage(), (Object)e);
            }
        }
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(registryBuilder.build());
        poolingConnectionManager.setMaxTotal(restTemplateConfig.getMaxTotal());
        poolingConnectionManager.setDefaultMaxPerRoute(restTemplateConfig.getDefaultMaxPerRoute());
        clientBuilder.setConnectionManager((HttpClientConnectionManager)poolingConnectionManager);
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)clientBuilder.build());
        clientHttpRequestFactory.setConnectTimeout(restTemplateConfig.getConnectionTimeout());
        clientHttpRequestFactory.setReadTimeout(restTemplateConfig.getReadTimeout());
        clientHttpRequestFactory.setConnectionRequestTimeout(restTemplateConfig.getConnectionRequestTimeout());
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(Charset.forName("UTF-8")));
        restTemplate.getMessageConverters().add(new WxMappingJackson2HttpMessageConverter());
        return restTemplate;
    }

    public WxaccountsConfig getWxaccountsConfig() {
        return this.wxaccountsConfig;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public WXBizMsgCrypt getWxBizMsgCrypt() {
        return this.wxBizMsgCrypt;
    }

    public AccountCertUtilsService getAccountCertUtilsService() {
        return this.accountCertUtilsService;
    }

    public void setWxaccountsConfig(WxaccountsConfig wxaccountsConfig) {
        this.wxaccountsConfig = wxaccountsConfig;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setWxBizMsgCrypt(WXBizMsgCrypt wxBizMsgCrypt) {
        this.wxBizMsgCrypt = wxBizMsgCrypt;
    }

    public void setAccountCertUtilsService(AccountCertUtilsService accountCertUtilsService) {
        this.accountCertUtilsService = accountCertUtilsService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxaccountsClient)) {
            return false;
        }
        WxaccountsClient other = (WxaccountsClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WxaccountsConfig this$wxaccountsConfig = this.getWxaccountsConfig();
        WxaccountsConfig other$wxaccountsConfig = other.getWxaccountsConfig();
        if (this$wxaccountsConfig == null ? other$wxaccountsConfig != null : !((Object)this$wxaccountsConfig).equals(other$wxaccountsConfig)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        WXBizMsgCrypt this$wxBizMsgCrypt = this.getWxBizMsgCrypt();
        WXBizMsgCrypt other$wxBizMsgCrypt = other.getWxBizMsgCrypt();
        if (this$wxBizMsgCrypt == null ? other$wxBizMsgCrypt != null : !this$wxBizMsgCrypt.equals(other$wxBizMsgCrypt)) {
            return false;
        }
        AccountCertUtilsService this$accountCertUtilsService = this.getAccountCertUtilsService();
        AccountCertUtilsService other$accountCertUtilsService = other.getAccountCertUtilsService();
        return !(this$accountCertUtilsService == null ? other$accountCertUtilsService != null : !this$accountCertUtilsService.equals(other$accountCertUtilsService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxaccountsClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WxaccountsConfig $wxaccountsConfig = this.getWxaccountsConfig();
        result = result * 59 + ($wxaccountsConfig == null ? 43 : ((Object)$wxaccountsConfig).hashCode());
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        WXBizMsgCrypt $wxBizMsgCrypt = this.getWxBizMsgCrypt();
        result = result * 59 + ($wxBizMsgCrypt == null ? 43 : $wxBizMsgCrypt.hashCode());
        AccountCertUtilsService $accountCertUtilsService = this.getAccountCertUtilsService();
        result = result * 59 + ($accountCertUtilsService == null ? 43 : $accountCertUtilsService.hashCode());
        return result;
    }

    public String toString() {
        return "WxaccountsClient(wxaccountsConfig=" + this.getWxaccountsConfig() + ", restTemplate=" + this.getRestTemplate() + ", wxBizMsgCrypt=" + this.getWxBizMsgCrypt() + ", accountCertUtilsService=" + this.getAccountCertUtilsService() + ")";
    }

    public class WxMappingJackson2HttpMessageConverter
    extends MappingJackson2HttpMessageConverter {
        public WxMappingJackson2HttpMessageConverter() {
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(MediaType.TEXT_PLAIN);
            mediaTypes.add(MediaType.APPLICATION_JSON);
            mediaTypes.add(MediaType.ALL);
            this.setSupportedMediaTypes(mediaTypes);
        }
    }
}

