/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.wxaccount.utils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public interface MapXml
extends Serializable {
    default public String toXml() {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<xml>");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object obj = field.get(this);
                if (obj == null) continue;
                if (obj instanceof String) {
                    String str = (String)obj;
                    if ("".equals(str)) continue;
                    map.put(field.getName(), obj);
                    sb.append("<").append(field.getName()).append("><![CDATA[").append(obj).append("]]></").append(field.getName()).append(">");
                    continue;
                }
                map.put(field.getName(), obj);
                sb.append("<").append(field.getName()).append("><![CDATA[").append(obj).append("]]></").append(field.getName()).append(">");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        sb.append("</xml>");
        return sb.toString();
    }

    default public Map<String, Object> toMap(String ... params) {
        Field[] fields;
        boolean cont = false;
        List<Object> paramsList = new ArrayList();
        if (params != null && params.length > 0) {
            cont = true;
            paramsList = Arrays.asList(params);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            if (cont && paramsList.contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(this);
                if (obj == null) continue;
                if (obj instanceof String) {
                    String str = (String)obj;
                    if (!StringUtils.isNotEmpty((CharSequence)str)) continue;
                    map.put(field.getName().replace("_$_", ""), obj);
                    continue;
                }
                map.put(field.getName(), obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    default public Map<String, Object> toAllMap(String ... params) {
        boolean cont = false;
        List<Object> paramsList = new ArrayList();
        if (params != null && params.length > 0) {
            cont = true;
            paramsList = Arrays.asList(params);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List fields = FieldUtils.getAllFieldsList(this.getClass());
        for (Field field : fields) {
            if (cont && paramsList.contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(this);
                if (obj == null) continue;
                map.put(field.getName(), obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    default public Map<String, String> getValMap(String ... params) {
        if (params == null || params.length == 0) {
            return null;
        }
        try {
            List fieldList = FieldUtils.getAllFieldsList(this.getClass());
            HashMap fieldMap = new HashMap();
            if (fieldList == null || fieldList.isEmpty()) {
                return null;
            }
            fieldList.forEach(field -> fieldMap.put(field.getName(), field));
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : params) {
                Field field2 = (Field)fieldMap.get(param);
                if (field2 == null) continue;
                field2.setAccessible(true);
                Object obj = field2.get(this);
                map.put(param, obj != null ? obj.toString() : "");
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

