/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.wxaccount.utils;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signature {
    private static final Logger log = LoggerFactory.getLogger(Signature.class);

    public static String getSign(Map<String, Object> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!Objects.nonNull(entry.getValue())) continue;
            log.debug("{}==>{}", (Object)entry.getKey(), entry.getValue());
            list.add(entry.getKey() + "=" + entry.getValue() + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String param = sb.substring(0, sb.length() - 1);
        log.debug("parma : {}", (Object)param);
        return Signature.sha1Encrypt(param);
    }

    public static String sha1Encrypt(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
            mdTemp.update(str.getBytes("UTF-8"));
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] buf = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
                buf[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(buf);
        }
        catch (Exception e) {
            return null;
        }
    }
}

