/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.wxaccount.utils;

import com.ysscale.framework.utils.ClazzUtils;
import com.ysscale.framework.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlMapUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlMapUtil.class);

    public static Map<String, String> xmlToMap(String xml, String charset) throws IllegalStateException {
        HashMap<String, String> respMap = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read((InputStream)new ByteArrayInputStream(xml.getBytes(charset)));
        }
        catch (DocumentException e) {
            throw new IllegalStateException("XML\u89e3\u6790\u5931\u8d25\uff01" + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("XML\u89e3\u6790\u5931\u8d25\uff01" + e.getMessage());
        }
        Element root = doc.getRootElement();
        XmlMapUtil.xmlToMap(root, respMap);
        return respMap;
    }

    public static Map<String, String> xmlToMap(Element tmpElement, Map<String, String> respMap) {
        if (tmpElement.isTextOnly()) {
            respMap.put(tmpElement.getName(), tmpElement.getText());
            return respMap;
        }
        Iterator eItor = tmpElement.elementIterator();
        while (eItor.hasNext()) {
            Element element = (Element)eItor.next();
            XmlMapUtil.xmlToMap(element, respMap);
        }
        return respMap;
    }

    public static String toXml(Map params) {
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>");
        for (Map.Entry entry : params.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (StringUtils.isBlank((String)value)) continue;
            xml.append("<").append(key).append(">");
            xml.append(entry.getValue());
            xml.append("</").append(key).append(">");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    public static <T> T mapToBean(Map map, Class<T> clazz) {
        if (Objects.isNull(map) || map.isEmpty()) {
            return null;
        }
        try {
            Object res = clazz.newInstance();
            Map fields = ClazzUtils.getAllFields(clazz);
            map.forEach((key, val) -> {
                try {
                    String keyName = StringUtil.firstToLowerCase((String)key.toString());
                    Field field = (Field)fields.get(keyName);
                    if (Objects.nonNull(field)) {
                        field.setAccessible(true);
                        field.set(res, val);
                    }
                }
                catch (Exception e) {
                    log.error("Field [{}] add error\uff1a{}", new Object[]{key, e.getMessage(), e});
                }
            });
            return res;
        }
        catch (Exception e) {
            log.error("Map To Bean error\uff1a{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }
}

