package com.jhscale;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.jhscale.alipay.config.AliPayConfig;
import com.jhscale.pay.config.PayConfig;
import com.jhscale.wxpay.client.WxPayClient;
import com.jhscale.wxpay.config.WxPayConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * @author lie_w
 * @title: WxPayConfiguration
 * @projectName rely-on-pay
 * @description: TODO
 * @date 2019/11/312:54
 */
@ComponentScan
@Configuration
public class PayConfiguration {

    @Bean(name = "wxPayConfig")
    @ConditionalOnMissingBean
    public WxPayConfig wxPayConfig() {
        return new WxPayConfig();
    }

    @Bean(name = "wxPayClient")
    @ConditionalOnMissingBean
    public WxPayClient wxPayClient(WxPayConfig wxPayConfig) throws Exception {
        return new WxPayClient(wxPayConfig);
    }

    @Bean(name = "aliPayConfig")
    @ConditionalOnMissingBean
    public AliPayConfig aliPayConfig() {
        return new AliPayConfig();
    }

    @Bean(name = "aliPayClient")
    @ConditionalOnMissingBean
    public AlipayClient aliPayClient(AliPayConfig aliPayConfig) throws Exception {
        return new DefaultAlipayClient(AliPayConfig.URL,
                aliPayConfig.getAppId(),
                aliPayConfig.getAppPrivateKey(),
                AliPayConfig.FORMAT,
                AliPayConfig.CHARSET,
                aliPayConfig.getAliPayPublicKey(),
                aliPayConfig.getSignType());
    }

    @Bean
    public PayConfig payConfig() {
        return new PayConfig();
    }

}
