package com.jhscale.pay.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

/**
 * @author lie_w
 * @title: PayConfig
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2019/11/2322:50
 */
@Data
@EnableConfigurationProperties
@ConfigurationProperties(prefix = "com.jhscale.cloud-pay")
public class PayConfig {

    /**
     * 支付宝默认关闭时间
     */
    private String aliDefaultCloseTime = "2m";

    /**
     * 微信默认关闭时间
     */
    private int wxDefaultCloseTime = 120000;
}
