package com.jhscale.pay.model;

import com.ysscale.framework.orderem.DeviceHandleStateEnum;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * @author lie_w
 * @title: BaseOrderRes
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2019/11/259:11
 */
@Data
@NoArgsConstructor
public class BasePayRes {

    // 交易状态【传递】
    private DeviceHandleStateEnum handleState;

    // 交易类型
    private String paySign;

    // 错误码
    private String errCode;

    // 错误信息
    private String errMsg;

    // 结束时间
    private Date endTime = new Date();

    public BasePayRes(String paySign) {
        this.paySign = paySign;
    }

    public String getErrMsg() {
        if (StringUtils.isNotBlank(paySign)) {
            return this.paySign + this.errMsg;
        }
        return errMsg;
    }
}
