package com.jhscale.pay.req;

import com.jhscale.pay.model.BasePayReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author lie_w
 * @title: RefundOrderReq
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2019/11/250:50
 */
@Data
public class RefundOrderReq extends BasePayReq {

    @ApiModelProperty(value = "设备号", name = "mac", required = true)
    private String mac;

    @ApiModelProperty(value = "本系统订单号", name = "orderNo", required = true)
    private String orderNo;

    @ApiModelProperty(value = "订单金额,单位为元", name = "cashFee", required = true)
    private BigDecimal cashFee;

    @ApiModelProperty(value = "退款金额,单位为元", name = "refunFee", required = true)
    private BigDecimal refundFee;

    @ApiModelProperty(value = "本系统退款订单号", name = "refundNo", required = true)
    private String refundNo;

    @ApiModelProperty(value = "退款原因", name = "refundReason")
    private String refundReason;

    @ApiModelProperty(value = "门店id", name = "storeId", required = true)
    private String storeId;

    @ApiModelProperty(value = "商户操作员编号", name = "adminId", required = true)
    private String adminId;

    @ApiModelProperty(value = "门店名称", name = "storeName")
    private String storeName;

    @ApiModelProperty(value = "门店行政区划码", name = "areaCode")
    private String areaCode;
}
