package com.jhscale.pay.res;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.jhscale.pay.model.BasePayRes;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author lie_w
 * @title: AliPayAuthorizationRes
 * @projectName ysscale-core
 * @description: TODO
 * @date 2019/11/2322:21
 */
@Data
@NoArgsConstructor
public class AliPayAuthorizationRes extends BasePayRes {

    /**
     * 商户PID
     */
    private String pId;

    /**
     * 支付宝支付令牌
     */
    private String payAliToken;

    /**
     * 支付宝刷新令牌
     */
    private String refreshAliToken;

    /**
     * 支付宝令牌失效时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date aliTokenCreate;

    public String getpId() {
        return pId;
    }

    public void setpId(String pId) {
        this.pId = pId;
    }

    public AliPayAuthorizationRes(String paySign) {
        super(paySign);
    }
}
