package com.jhscale.pay.res;

import com.jhscale.pay.model.BasePayRes;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @author lie_w
 * @title: CancelOrderRes
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2019/11/250:54
 */
@Data
@NoArgsConstructor
public class CancelOrderRes extends BasePayRes {

    // 支付宝重试 N/Y
    private String retryFlag;

    // close：交易未支付，触发关闭交易动作，无退款；
    // refund：交易已支付，触发交易退款动作；
    // 未返回：未查询到交易，或接口调用失败；
    private String action;

    // 当撤销产生了退款时，返回退款时间
    private Date gmtRefundPay;

    public CancelOrderRes(String paySign) {
        super(paySign);
    }
}
