package com.jhscale.wxpay.config;

import com.jhscale.wxpay.utils.WxConstant;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author lie_w
 * @title: WxPayConfig
 * @projectName rely-on-pay
 * @description: TODO
 * @date 2019/11/211:20
 */
@Data
@ConfigurationProperties(prefix = "com.jhscale.wx")
public class WxPayConfig {

    /**
     * 服务商商户号
     */
    private String mch_id;


    /**
     * appid
     */
    private String appid;

    /**
     * API密钥
     */
    private String key;


    /**
     * app_secret
     */
    private String appSecret;


    /**
     * 回调地址
     */
    private String notifyUrl;


    /**
     * 证书地址 当设置了证书地址后就会开启证书https访问接口
     */
    private String certLocalPath;

    /**
     * 证书密码
     */
    private String certPassword;

    /**
     * APIv3密钥
     */
    private String v3AESKey;

    /**
     * 微信跨城容灾渠道
     */
    private String channel;

    public String getChannel() {
        if (StringUtils.isBlank(channel) || "maseter".equalsIgnoreCase(channel)) {
            return WxConstant.WX_MASTER_CHANNEL;
        } else {
            return WxConstant.WX_SECOND_CHANNEL;
        }
    }
}
