package com.jhscale.wxpay.model;

import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.utils.RandomGenerator;
import com.jhscale.wxpay.utils.Sha1Util;
import com.jhscale.wxpay.utils.Signature;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

/**
 * @author lie_w
 * @title: WxpayReq
 * @projectName rely-on-pay
 * @description: TODO
 * @date 2019/11/321:45
 */
public interface WxPayReq<T> extends MapXml {

    String getUrl(String channel);

    void setNonce_str(String nonce_str);

    String getNonce_str();

    void setSign(String sign);

    default String getSign_type() {
        return "";
    }

    default void initSign(String key) {
        String sign = "";
        if (ObjectUtils.isEmpty(getSign_type()) || "MD5".equals(getSign_type())) {
            sign = Signature.getSign(toMap(ignoreFileds()), key);
        } else {
            sign = Sha1Util.paySignDesposit(toMap(ignoreFileds()), key);
        }
        setSign(sign);
    }

    default void randomNonceStr() {
        setNonce_str(RandomGenerator.getRandomStringByLength(32));
    }

    default void initConfig(WxPayConfig wxPayConfig) {
        beforeInit();
        BeanUtils.copyProperties(wxPayConfig, this);
    }

    /**
     * 初始化前
     */
    default void beforeInit() {

    }

    /**
     * 签名忽略的字段
     *
     * @return
     */
    default String[] ignoreFileds() {
        return null;
    }

    /**
     * 返回值类型
     *
     * @return
     */
    Class getResClass();

    /**
     * Restemplate 返回对象值
     *
     * @param tClass
     * @return
     */
    default Class getResultType(Class tClass) {
        return tClass;
    }

    /**
     * 返回对象处理   默认Restemplate 设置返回值对象
     *
     * @param res 返回结果
     * @param <T> 返回对象类型
     * @return
     */
    default <T> T getResult(T res, WxPayConfig wxPayConfig) {
        return res;
    }

    /**
     * 数据发送接口
     */
    default Object sendReq(RestTemplate restTemplate, WxPayConfig wxPayConfig, Class tClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_XML);
        HttpEntity<String> httpEntity = new HttpEntity<>(toXml(), headers);
        return getResult(restTemplate.postForObject(getUrl(wxPayConfig.getChannel()), httpEntity, getResultType(tClass)), wxPayConfig);
    }
}
