package com.jhscale.wxpay.req;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.GetcertficatesRes;
import com.jhscale.wxpay.utils.AesGcmExample2;
import com.jhscale.wxpay.utils.XMLUtils;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 微信获取平台证书
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_2
 */
@Data
public class GetcertficatesReq implements WxPayReq<GetcertficatesRes> {
    @Override
    public String getUrl(String channel) {
        return channel + "/risk/getcertficates";
    }

    /**
     * 商户号 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 随机字符串，不长于32位。推荐随机数生成算法
     */
    private String nonce_str;

    /**
     * 签名 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 签名方式 暂只支持HMAC-SHA256
     */
    private String sign_type = "HMAC-SHA256";

    @Override
    public Class<GetcertficatesRes> getResClass() {
        return GetcertficatesRes.class;
    }

    @Override
    public Class getResultType(Class tClass) {
        return String.class;
    }

    @Override
    public GetcertficatesRes getResult(Object res, WxPayConfig wxPayConfig) {
        GetcertficatesRes result;
        try {
            result = (GetcertficatesRes) XMLUtils.convertXmlStrToObject(GetcertficatesRes.class, (String) res);
            JSONObject certificates = JSONObject.parseObject(result.getCertificates());
            List<Map<String, Object>> data = (List) JSONObject.parseArray(certificates.getString("data"));
            Map<String, Object> certificateMap = new HashMap<>();
            if (data != null && !data.isEmpty()) {
                certificateMap = data.get(0);
            }
            String serial_no = (String) certificateMap.get("serial_no");
            String effective_time = (String) certificateMap.get("effective_time");
            String expire_time = (String) certificateMap.get("expire_time");

            JSONObject encrypt_certificate = (JSONObject) certificateMap.get("encrypt_certificate");
            String algorithm = (String) encrypt_certificate.get("algorithm");
            String nonce = (String) encrypt_certificate.get("nonce");
            String associated_data = (String) encrypt_certificate.get("associated_data");
            String ciphertext = (String) encrypt_certificate.get("ciphertext");
            String cert = AesGcmExample2.aesgcmDecrypt(wxPayConfig.getV3AESKey(), associated_data, nonce, ciphertext);

            result.setSerial_no(serial_no);
            result.setEffective_time(effective_time);
            result.setExpire_time(expire_time);
            result.setCert(cert);
        } catch (Exception e) {
            result = new GetcertficatesRes();
            result.setReturn_code("FAIL");
            result.setReturn_msg("证书解析失败");
        }
        return result;
    }
}
