package com.jhscale.wxpay.req;

import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MicroAddRecommendConfRes;
import com.jhscale.wxpay.res.MicroModifyarchivesRes;
import com.jhscale.wxpay.utils.XMLUtils;
import lombok.Data;

/**
 * 小微商户 小微商户关注功能配置API
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=20_0&index=1
 */
@Data
public class MicroAddRecommendConfReq implements WxPayReq<MicroAddRecommendConfRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/mkt/addrecommendconf";
    }

    /**
     * 商户号 [是] 服务商的商户号
     */
    private String mch_id;

    /**
     * 小微商户号 [是] 	服务商报备的小微商户识别码
     */
    private String sub_mch_id;

    /**
     * 关联APPID [是] 该字段视支付接口中是否传sub_appid而定，如果没有填sub_appid,此处请填值NULL，否则请填写绑定服务商公众号、小程序、APP支付等对应的APPID
     */
    private String sub_appid;

    /**
     * 推荐关注APPID [否] 签名，服务商的公众号APPID 二选一
     */
    private String subscribe_appid;

    /**
     * 支付凭证推荐小程序appid [否] 需为通过微信认证的小程序appid，且认证主体与服务商主体一致 二选一
     */
    private String receipt_appid;

    /**
     * 随机字符串 [是] 随机字符串，不长于32位。推荐随机数生成算法
     */
    private String nonce_str;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 签名算法类型 [是] 暂只支持HMAC-SHA256算法。该字段需参与签名sign的计算。
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return MicroModifyarchivesRes.class;
    }

    @Override
    public Class getResultType(Class tClass) {
        return String.class;
    }

    @Override
    public MicroModifyarchivesRes getResult(Object res, WxPayConfig wxPayConfig) {
        MicroModifyarchivesRes result = (MicroModifyarchivesRes) XMLUtils.convertXmlStrToObject(MicroModifyarchivesRes.class, (String) res);
        return result;
    }
}
