package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MicroAddSubAppidConfigRes;
import com.jhscale.wxpay.res.MicroAddSubDirConfigRes;
import lombok.Data;

/**
 * 小微商户 小微商户新增对应APPID关联API
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=20_3&index=3
 */
@Data
public class MicroAddSubAppidConfigReq implements WxPayReq<MicroAddSubAppidConfigRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/mch/addsubdevconfig";
    }

    /**
     * 公众帐号ID [是] 服务商的公众账号 ID
     */
    private String appid;

    /**
     * 商户号 [是] 服务商的商户号
     */
    private String mch_id;

    /**
     * 小微商户号 [是] 	服务商报备的小微商户识别码
     */
    private String sub_mch_id;

    /**
     * 关联APPID [是] 绑定服务商道公众号、小程序、APP支付等对应的APPID
     */
    private String sub_appid;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 随机字符串 [否] 配合结构使用
     */
    private String nonce_str;

    @Override
    public void randomNonceStr() {

    }

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return MicroAddSubDirConfigRes.class;
    }
}
