package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MicroAddSubDirConfigRes;
import lombok.Data;

/**
 * 小微商户 小微商户开发配置新增支付目录API
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=20_2&index=2
 */
@Data
public class MicroAddSubDirConfigReq implements WxPayReq<MicroAddSubDirConfigRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/mch/addsubdevconfig";
    }

    /**
     * 公众帐号ID [是] 服务商的公众账号 ID
     */
    private String appid;

    /**
     * 商户号 [是] 服务商的商户号
     */
    private String mch_id;

    /**
     * 小微商户号 [是] 	服务商报备的小微商户识别码
     */
    private String sub_mch_id;

    /**
     * 授权目录 [是] 公众账号JS API支付授权目录 ，要求符合URI格式规范，每次添加一个支付目录，最多5个
     */
    private String jsapi_path;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 随机字符串 [否] 配合结构使用
     */
    private String nonce_str;

    @Override
    public void randomNonceStr() {

    }

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return MicroAddSubDirConfigRes.class;
    }
}
