package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MicroModifyContactInfoRes;
import lombok.Data;

/**
 * 小微商户 修改联系信息
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=21_4
 */
@Data
public class MicroModifyContactInfoReq implements WxPayReq<MicroModifyContactInfoRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/applyment/micro/modifycontactinfo";
    }

    /**
     * 接口版本号 [是] 默认值1.0
     */
    private String version = "1.0";

    /**
     * 商户号 [是] 服务商的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 [是] 参考签名规则
     */
    private String nonce_str;

    /**
     * 签名类型 [是] 签名类型，仅支持HMAC-SHA256。该字段需参与签名sign的计算。
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 小微商户号 [是] 小微商户的商户号
     */
    private String sub_mch_id;

    /**
     * 手机号 [否] 小微商户手机号，该字段属于敏感信息，需要进行加密处理，加密方法详见敏感信息加密说明
     */
    private String mobile_phone;

    /**
     * 邮箱 [否] 小微商户邮箱，该字段属于敏感信息，需要进行加密处理，加密方法详见敏感信息加密说明
     */
    private String email;

    /**
     * 商户简称 [否]
     */
    private String merchant_name;

    /**
     * 加密的平台证书序列号 [是] 用于对敏感信息进行加密的平台证书序列号，获取方法详见平台证书及序列号获取接口（接口返回参数ተserial_noቱ即为平台证书序列号）
     */
    private String cert_sn;

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return MicroModifyContactInfoRes.class;
    }
}
