package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.OrderQueryRes;
import lombok.Data;

/**
 * 查询订单接口
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_2
 */
@Data
public class OrderQueryReq implements WxPayReq<OrderQueryRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/pay/orderquery";
    }

    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户公众账号ID [否] 服务商下使用
     */
    private String sub_appid;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 微信订单号 与 out_trade_no 二选一
     */
    private String transaction_id;

    /**
     * 商户订单号 与 transaction_id 二选一
     */
    private String out_trade_no;

    /**
     * 签名类型 [否]
     */
    private String sign_type;


    @Override
    public Class<OrderQueryRes> getResClass() {
        return OrderQueryRes.class;
    }
}
