package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ProfitSharingAddReceiverRes;
import lombok.Data;

/**
 * 添加分账接收方
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_3&index=4
 */
@Data
public class ProfitSharingAddReceiverReq implements WxPayReq<ProfitSharingAddReceiverRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/pay/profitsharingaddreceiver";
    }

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户号 [是] 微信支付分配的子商户号
     */
    private String sub_mch_id;

    /**
     * 公众账号ID [是]
     */
    private String appid;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 签名类型 [否]
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 分账接收方 [是]
     */
    private String receiver;


    @Override
    public Class<ProfitSharingAddReceiverRes> getResClass() {
        return ProfitSharingAddReceiverRes.class;
    }
}
