package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ProfitSharingRemoveReceiverRes;
import lombok.Data;

/**
 * 删除分账接收方
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_4&index=5
 */
@Data
public class ProfitSharingRemoveReceiverReq implements WxPayReq<ProfitSharingRemoveReceiverRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/pay/profitsharingremovereceiver";
    }

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户号 [是] 微信支付分配的子商户号
     */
    private String sub_mch_id;

    /**
     * 公众账号ID [是]
     */
    private String appid;

    /**
     * 子商户公众账号ID [是] 微信分配的子商户公众账号ID
     */
    private String sub_appid;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 签名类型 [否]
     */
    private String sign_type;

    /**
     * 分账接收方 [是]
     */
    private String receiver;

    @Override
    public Class<ProfitSharingRemoveReceiverRes> getResClass() {
        return ProfitSharingRemoveReceiverRes.class;
    }
}
