package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.RefundRes;
import lombok.Data;

/**
 * 退款接口
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_4
 */
@Data
public class RefundReq implements WxPayReq<RefundRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/pay/refund";
    }

    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户公众账号ID [否] 服务商下使用
     */
    private String sub_appid;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;


    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 签名类型 [是]
     */
    private String sign_type;

    /**
     * 微信订单号 与 out_trade_no 二选一
     */
    private String transaction_id;

    /**
     * 商户订单号 与 transaction_id 二选一
     */
    private String out_trade_no;

    /**
     * 商户退款单号 [是]
     */
    private String out_refund_no;

    /**
     * 订单金额 [是]
     */
    private String total_fee;

    /**
     * 退款金额 [是]
     */
    private String refund_fee;

    /**
     * 货币种类 [否]
     */
    private String refund_fee_type;

    /**
     * 退款原因 [否]
     */
    private String refund_desc;

    /**
     * 退款资金来源 [否]
     */
    private String refund_account;

    /**
     * 退款结果通知url [否]
     */
    private String notify_url;

    @Override
    public Class<RefundRes> getResClass() {
        return RefundRes.class;
    }
}
