package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ReverseRes;
import lombok.Data;

/**
 * 撤销订单
 * https://pay.weixin.qq.com/wiki/doc/api/micropay.php?chapter=9_11&index=3
 */
@Data
public class ReverseReq implements WxPayReq<ReverseRes> {
    @Override
    public String getUrl(String channel) {
        return channel + "/secapi/pay/reverse";
    }

    /**
     * 公众账号ID [是] 微信分配的公众账号ID（企业号corpid即为此appId）
     */
    private String appid;

    /**
     * 商户号 [是] 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 子商户号 [是] 微信支付分配的子商户号
     */
    private String sub_mch_id;

    /**
     * 微信订单号 [否] 微信的订单号，优先使用
     */
    private String transaction_id;

    /**
     * 商户订单号 [是] 商户系统内部的订单号,transaction_id、out_trade_no二选一，如果同时存在优先级：transaction_id> out_trade_no
     */
    private String out_trade_no;

    /**
     * 随机字符串 [是] 随机字符串，不长于32位。推荐随机数生成算法
     */
    private String nonce_str;

    /**
     * 签名 [是] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 签名类型 [否] 签名类型，目前支持HMAC-SHA256和MD5，默认为MD5
     */
    private String sign_type;

    @Override
    public Class<ReverseRes> getResClass() {
        return ReverseRes.class;
    }
}
