package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 小微申请入驻
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_2
 */
@Data
public class ApplymentMicroSubmitRes extends WxPayRes {

    /**
     * 随机字符串 随机字符串
     */
    private String nonce_str;

    /**
     * 签名 参考2.2签名规则
     */
    private String sign;

    /**
     * 业务结果 SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 参考业务错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 参考业务错误码列表
     */
    private String err_code_des;

    /**
     * 参数校验不通过的字段名 当err_code为PARAM_ERROR时，返回有误的请求参数字段名。
     */
    private String err_param;

    /**
     * 商户申请单号 微信支付分配的申请单号
     */
    private String applyment_id;

}
