package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 特约商户 查询结算账户API
 * https://pay.weixin.qq.com/wiki/doc/api/mch_xiaowei.php?chapter=30_2&index=2
 */
@Data
public class MchSettlementRes extends WxPayRes {

    /**
     * 账户类型 返回特约商户的结算账户类型
     * 枚举值：
     * 对公银行账户：
     * ACCOUNT_TYPE_BUSINESS
     * 经营者个人银行卡：
     * ACCOUNT_TYPE_PRIVATE
     */
    private String account_type;

    /**
     * 开户银行 返回特约商户的结算账户-开户银行全称。
     */
    private String account_bank;

    /**
     * 开户银行全称（含支行） 返回特约商户的结算账户-开户银行全称（含支行）
     */
    private String bank_name;

    /**
     * 开户银行联行号 返回特约商户的结算账户-联行号
     */
    private String bank_branch_id;

    /**
     * 银行账号 返回特约商户的结算账户-银行账号，掩码显示
     */
    private String account_number;

    /**
     * 汇款验证结果 返回特约商户的结算账户-汇款验证结果
     * （1）VERIFYING：系统汇款验证中，商户可发起提现尝试；
     * （2）VERIFY_SUCCESS：系统成功汇款，该账户可正常发起提现；
     * （3）VERIFY_FAIL：系统汇款失败，该账户无法发起提现，请检查修改；
     */
    private String verify_result;
}
