package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * 小微商户 修改结算银行卡
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=21_2
 */
@Data
@XmlRootElement(name="xml")
public class MicroModifyarchivesRes extends WxPayRes {

    /**
     * 以下字段在return_code为SUCCESS的时候有返回
     */

    /**
     * 随机字符串 [否] 随机字符串
     */
    private String nonce_str;

    /**
     * 签名 [否] 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 业务结果 [否] SUCCESS/FAIL
     */
    private String result_code;

    /**
     * 错误代码 [否] 参考业务错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 [否] 参考业务错误码列表
     */
    private String err_code_des;

    /**
     * 商户号 [否] 服务商的商户号
     */
    private String mch_id;

    /**
     * 小微商户号 [否] 小微商户的商户号
     */
    private String sub_mch_id;
}
