package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 小微商户 查询提现状态
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=21_1
 */
@Data
public class MicroQueryAutoWithDrawByDateRes extends WxPayRes {

    /**
     * 当return_code为SUCCESS时，进一步返回以下字段
     */

    /**
     * 业务结果 此字段是业务标识，表示业务是否成功。目前只有SUCCESS和FAIL两种
     */
    private String result_code;

    /**
     * 错误代码 见错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 错误信息描述
     */
    private String err_code_des;

    /**
     * 签名类型 签名类型，目前支持HMAC-SHA256
     */
    private String sign_type;

    /**
     * 签名 签名，详见签名生成算法
     */
    private String sign;

    /**
     * 当return_code和result_code都为SUCCESS的时候，还会包含以下字段
     */

    /**
     * 日期 日期
     */
    private String date;

    /**
     * 商户号 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 小微商户号 微信支付分配的商户号
     */
    private String sub_mch_id;

    /**
     * 随机字符 随机字符串(与请求一致)
     */
    private String nonce_str;

    /**
     * 单据状态 见单据状态描述
     */
    private String withdraw_status;

    /**
     * 单据失败原因 错误原因描述
     */
    private String fail_reason;

    /**
     * 提现单单据ID 如果该日存在提现单据，则表示提现单据的ID
     */
    private String withdraw_id;

    /**
     * 金额 分（RMB）
     */
    private String amount;

    /**
     * 单据创建时间 时间格式为YYYY-MM-ddHH:mm:ss
     */
    private String create_time;

    /**
     * 单据成功时间 时间格式为YYYY-MM-ddHH:mm:ss
     */
    private String success_time;

    /**
     * 单据退票时间 时间格式为YYYY-MM-ddHH:mm:ss
     */
    private String refund_time;
}
