package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 添加分账接收方
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_3&index=4
 */
@Data
public class ProfitSharingAddReceiverRes extends WxPayRes {

    /**
     * 业务结果
     * SUCCESS：添加分账接收方成功
     * FAIL ：提交业务失败
     */
    private String result_code;

    /**
     * 错误代码 列表详见错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 结果信息描述
     */
    private String err_code_des;

    /**
     * 商户号 调用接口时提供的商户号
     */
    private String mch_id;

    /**
     * 子商户号 微信支付分配特约商户的商户号
     */
    private String sub_mch_id;

    /**
     * 公众账号ID 调用接口提供的公众账号ID
     */
    private String appid;

    /**
     * 子商户公众账号ID 微信分配的子商户公众账号ID
     */
    private String sub_appid;

    /**
     * 分账接收方 分账接收方对象（不包含分账接收方全称），json格式
     * {"type":"MERCHANT_ID","account":"190001001"}
     */
    private String receiver;

    /**
     * 随机字符串 微信返回的随机字符串
     */
    private String nonce_str;

    /**
     * 签名 微信返回的签名，详见签名算法
     */
    private String sign;

}
