package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 查询分账结果
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_2&index=3
 */
@Data
public class ProfitSharingQueryRes extends WxPayRes {

    /**
     * 业务结果
     * SUCCESS：分账申请接收成功，结果通过分账查询接口查询
     * FAIL ：提交业务失败
     */
    private String result_code;

    /**
     * 错误代码 列表详见错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 结果信息描述
     */
    private String err_code_des;

    /**
     * 商户号 调用接口时提供的商户号
     */
    private String mch_id;

    /**
     * 子商户号 微信支付分配特约商户的商户号
     */
    private String sub_mch_id;

    /**
     * 随机字符串 微信返回的随机字符串
     */
    private String nonce_str;

    /**
     * 签名 微信返回的签名，详见签名算法
     */
    private String sign;

    /**
     * 以下字段在return_code和result_code都为SUCCESS的时候返回
     */

    /**
     * 微信订单号 微信支付订单号
     */
    private String transaction_id;

    /**
     * 商户分账单号 商户系统内部的分账单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一分账单号多次请求等同一次。
     */
    private String out_order_no;

    /**
     * 微信分账单号 微信分账单号
     */
    private String order_id;

    /**
     * 分账单状态
     * ACCEPTED—受理成功
     * PROCESSING—处理中
     * FINISHED—处理完成
     * CLOSED—处理失败，已关单
     */
    private String status;

    /**
     * 关单原因 NO_AUTH:分账授权已解除
     */
    private String close_reason;

    /**
     * 分账接收方列表 分账接收方列表，json对象详细说明见下文，仅当查询分账请求结果时，存在本字段点击行前的+展开字段详情
     */
    private String receivers;

    /**
     * 分账金额 分账完结的分账金额，单位为分， 仅当查询分账完结的执行结果时，存在本字段
     */
    private String amount;

    /**
     * 分账描述 分账完结的原因描述，仅当查询分账完结的执行结果时，存在本字段
     */
    private String description;

    /**
     * 分账列表信息
     */
    @Data
    public static class ProfitSharingReceiver {

        /**
         * 分账接收方类型
         * MERCHANT_ID：商户ID
         * PERSONAL_WECHATID：个人微信名PERSONAL_OPENID：个人openid（由父商户APPID转换得到）PERSONAL_SUB_OPENID: 个人sub_openid（由子商户APPID转换得到）
         */
        private String type;

        /**
         * 分账接收方帐号
         * 类型是MERCHANT_ID时，是商户ID
         * 类型是PERSONAL_WECHATID时，是个人微信名
         * 类型是PERSONAL_OPENID时，是个人openid
         * 类型是PERSONAL_SUB_OPENID时，是个人sub_openid
         */
        private String account;

        /**
         * 分账金额 分账金额，单位为分，只能为整数，不能超过原订单支付金额及最大分账比例金额
         */
        private String amount;

        /**
         * 分账描述 分账的原因描述，分账账单中需要体现
         */
        private String description;

        /**
         * 分账结果
         * PENDING:待分账
         * SUCCESS:分账成功
         * ADJUST:分账失败待调账
         * RETURNED:已转回分账方
         * CLOSED: 已关闭
         */
        private String result;

        /**
         * 分账完成时间 分账完成时间
         */
        private String finish_time;

        /**
         * 分账失败原因
         * ACCOUNT_ABNORMAL:分账接收账户异常
         * NO_RELATION：分账关系已解除
         */
        private String fail_reason;
    }


}
