package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 请求单次分账
 * https://pay.weixin.qq.com/wiki/doc/api/allocation_sl.php?chapter=25_1&index=1
 */
@Data
public class ProfitSharingRes extends WxPayRes {

    /**
     * 业务结果
     * SUCCESS：分账申请接收成功，结果通过分账查询接口查询
     * FAIL ：提交业务失败
     */
    private String result_code;

    /**
     * 错误代码 列表详见错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 结果信息描述
     */
    private String err_code_des;

    /**
     * 商户号 调用接口时提供的商户号
     */
    private String mch_id;

    /**
     * 子商户号 微信支付分配特约商户的商户号
     */
    private String sub_mch_id;

    /**
     * 公众账号ID 调用接口提供的公众账号ID
     */
    private String appid;

    /**
     * 子商户公众账号ID 微信分配的子商户公众账号ID
     */
    private String sub_appid;

    /**
     * 随机字符串 微信返回的随机字符串
     */
    private String nonce_str;

    /**
     * 签名 微信返回的签名，详见签名算法
     */
    private String sign;

    /**
     * 以下字段在return_code和result_code都为SUCCESS的时候返回
     */

    /**
     * 微信订单号 微信支付订单号
     */
    private String transaction_id;

    /**
     * 商户分账单号 调用接口提供的商户系统内部的分账单号
     */
    private String out_order_no;

    /**
     * 微信分账单号 微信分账单号，微信系统返回的唯一标识
     */
    private String order_id;

}
