package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 查询退款
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_5
 */
@Data
public class RefundQueryRes extends WxPayRes {

    /**
     * 业务结果 SUCCESS/FAIL
     * SUCCESS退款申请接收成功，结果通过退款查询接口查询
     * FAIL
     */
    private String result_code;

    /**
     * 错误码 错误码详见第6节
     */
    private String err_code;

    /**
     * 错误描述 结果信息描述
     */
    private String err_code_des;

    /**
     * 小程序ID 微信分配的小程序ID
     */
    private String appid;

    /**
     * 商户号 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 随机字符串，不长于32位
     */
    private String nonce_str;

    /**
     * 签名 签名，详见签名算法
     */
    private String sign;

    /**
     * 订单总退款次数 订单总共已发生的部分退款次数，当请求参数传入offset后有返回
     */
    private String total_refund_count;

    /**
     * 微信订单号 微信订单号
     */
    private String transaction_id;

    /**
     * 商户订单号 商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一。
     */
    private String out_trade_no;

    /**
     * 订单金额 订单总金额，单位为分，只能为整数，详见支付金额
     */
    private String total_fee;

    /**
     * 应结订单金额 当订单使用了免充值型优惠券后返回该参数，应结订单金额=订单金额-免充值优惠券金额。
     */
    private String settlement_total_fee;

    /**
     * 货币种类 订单金额货币类型，符合ISO 4217标准的三位字母代码，默认人民币：CNY，其他值列表详见货币类型
     */
    private String fee_type;

    /**
     * 现金支付金额 现金支付金额，单位为分，只能为整数，详见支付金额
     */
    private String cash_fee;

    /**
     * 退款笔数 当前返回退款笔数
     */
    private String refund_count;

    /**
     * 商户退款单号 商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。
     */
    private String out_refund_no_$n;

    /**
     * 微信退款单号 微信退款单号
     */
    private String refund_id_$n;

    /**
     * 退款渠道
     * ORIGINAL—原路退款
     * BALANCE—退回到余额
     * OTHER_BALANCE—原账户异常退到其他余额账户
     * OTHER_BANKCARD—原银行卡异常退到其他银行卡
     */
    private String refund_channel_$n;

    /**
     * 申请退款金额 退款总金额,单位为分,可以做部分退款
     */
    private String refund_fee_$n;

    /**
     * 退款金额 退款金额=申请退款金额-非充值代金券退款金额，退款金额<=申请退款金额
     */
    private String settlement_refund_fee_$n;

    /**
     * 代金券类型
     * CASH--充值代金券
     * NO_CASH---非充值优惠券
     * 开通免充值券功能，并且订单使用了优惠券后有返回（取值：CASH、NO_CASH）。$n为下标,$m为下标,从0开始编号，举例：coupon_type_$0_$1
     */
    private String coupon_type_$n_$m;

    /**
     * 总代金券退款金额 代金券退款金额<=退款金额，退款金额-代金券或立减优惠退款金额为现金，说明详见代金券或立减优惠
     */
    private String coupon_refund_fee_$n;

    /**
     * 退款代金券使用数量 退款代金券使用数量 ,$n为下标,从0开始编号
     */
    private String coupon_refund_count_$n;

    /**
     * 退款代金券ID 退款代金券ID, $n为下标，$m为下标，从0开始编号
     */
    private String coupon_refund_id_$n_$m;

    /**
     * 单个代金券退款金额 单个退款代金券支付金额, $n为下标，$m为下标，从0开始编号
     */
    private String coupon_refund_fee_$n_$m;

    /**
     * 退款状态
     * SUCCESS—退款成功
     * REFUNDCLOSE—退款关闭。
     * PROCESSING—退款处理中
     * CHANGE—退款异常，退款到银行发现用户的卡作废或者冻结了，导致原路退款银行卡失败，可前往商户平台（pay.weixin.qq.com）-交易中心，手动处理此笔退款。$n为下标，从0开始编号。
     */
    private String refund_status_$n;

    /**
     * 退款资金来源
     * REFUND_SOURCE_RECHARGE_FUNDS---可用余额退款/基本账户
     * REFUND_SOURCE_UNSETTLED_FUNDS---未结算资金退款
     * $n为下标，从0开始编号
     */
    private String refund_account_$n;

    /**
     * 退款入账账户
     * 1）退回银行卡：{银行名称}{卡类型}{卡尾号}
     * 2）退回支付用户零钱:支付用户零钱
     * 3）退还商户:商户基本账户 商户结算银行账户
     * 4）退回支付用户零钱通:支付用户零钱通
     */
    private String refund_recv_accout_$n;

    /**
     * 退款成功时间 退款成功时间，当退款状态为退款成功时有返回。$n为下标，从0开始编号。
     */
    private String refund_success_time_$n;


}
