package com.jhscale.wxpay.res;

import com.jhscale.wxpay.model.WxPayRes;
import lombok.Data;

/**
 * 退款接口
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_4
 */
@Data
public class RefundRes extends WxPayRes {

    /**
     * 业务结果
     * SUCCESS/FAIL
     * SUCCESS退款申请接收成功，结果通过退款查询接口查询
     * FAIL 提交业务失败
     */
    private String result_code;

    /**
     * 错误代码 列表详见错误码列表
     */
    private String err_code;

    /**
     * 错误代码描述 结果信息描述
     */
    private String err_code_des;

    /**
     * 小程序ID 微信分配的小程序ID
     */
    private String appid;

    /**
     * 商户号 微信支付分配的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 随机字符串，不长于32位
     */
    private String nonce_str;

    /**
     * 签名 签名，详见签名算法
     */
    private String sign;

    /**
     * 微信订单号 微信订单号
     */
    private String transaction_id;

    /**
     * 商户订单号 商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一。
     */
    private String out_trade_no;

    /**
     * 商户退款单号 商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。
     */
    private String out_refund_no;

    /**
     * 微信退款单号 微信退款单号
     */
    private String refund_id;

    /**
     * 退款金额 退款总金额,单位为分,可以做部分退款
     */
    private String refund_fee;

    /**
     * 应结退款金额 去掉非充值代金券退款金额后的退款金额，退款金额=申请退款金额-非充值代金券退款金额，退款金额<=申请退款金额
     */
    private String settlement_refund_fee;

    /**
     * 标价金额 订单总金额，单位为分，只能为整数，详见支付金额
     */
    private String total_fee;

    /**
     * 应结订单金额 去掉非充值代金券金额后的订单总金额，应结订单金额=订单金额-非充值代金券金额，应结订单金额<=订单金额。
     */
    private String settlement_total_fee;

    /**
     * 标价币种 订单金额货币类型，符合ISO 4217标准的三位字母代码，默认人民币：CNY，其他值列表详见货币类型
     */
    private String fee_type;

    /**
     * 现金支付金额 现金支付金额，单位为分，只能为整数，详见支付金额
     */
    private String cash_fee;

    /**
     * 现金支付币种 货币类型，符合ISO 4217标准的三位字母代码，默认人民币：CNY，其他值列表详见货币类型
     */
    private String cash_fee_type;

    /**
     * 现金退款金额 现金退款金额，单位为分，只能为整数，详见支付金额
     */
    private String cash_refund_fee;

    /**
     * 代金券类型
     * CASH--充值代金券
     * NO_CASH---非充值代金券
     * 订单使用代金券时有返回（取值：CASH、NO_CASH）。$n为下标,从0开始编号，举例：coupon_type_0
     */
    private String coupon_type_$n;

    /**
     * 代金券退款总金额 代金券退款金额<=退款金额，退款金额-代金券或立减优惠退款金额为现金，说明详见代金券或立减优惠
     */
    private String coupon_refund_fee;

    /**
     * 单个代金券退款金额 代金券退款金额<=退款金额，退款金额-代金券或立减优惠退款金额为现金，说明详见代金券或立减优惠
     */
    private String coupon_refund_fee_$n;

    /**
     * 退款代金券使用数量 退款代金券使用数量
     */
    private String coupon_refund_count;

    /**
     * 退款代金券ID 退款代金券ID, $n为下标，从0开始编号
     */
    private String coupon_refund_id_$n;


}
