package com.jhscale;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.jhscale.alipay.config.AliPayConfig;
import com.jhscale.pay.config.PayConfig;
import com.jhscale.service.HttpMessageConverterService;
import com.jhscale.service.RestemplateService;
import com.jhscale.wxpay.client.WxPayClient;
import com.jhscale.wxpay.config.WxPayConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: WxPayConfiguration
 * @projectName rely-on-pay
 * @description: TODO
 * @date 2019/11/312:54
 */
@ComponentScan
@Configuration
public class PayConfiguration {

    @Autowired
    private RestTemplate restTemplate;

    @Bean(name = "wxPayConfig")
    @ConditionalOnMissingBean
    public WxPayConfig wxPayConfig() {
        return new WxPayConfig();
    }

    @Bean(name = "wxPayClient")
    @ConditionalOnMissingBean
    public WxPayClient wxPayClient(WxPayConfig wxPayConfig) throws Exception {
        return new WxPayClient(wxPayConfig, restTemplate);
    }

    @Bean(name = "aliPayConfig")
    @ConditionalOnMissingBean
    public AliPayConfig aliPayConfig() {
        return new AliPayConfig();
    }

    @Bean(name = "aliPayClient")
    @ConditionalOnMissingBean
    public AlipayClient aliPayClient(AliPayConfig aliPayConfig) throws Exception {
        return new DefaultAlipayClient(AliPayConfig.URL,
                aliPayConfig.getAppId(),
                aliPayConfig.getAppPrivateKey(),
                AliPayConfig.FORMAT,
                AliPayConfig.CHARSET,
                aliPayConfig.getAliPayPublicKey(),
                aliPayConfig.getSignType());
    }

    @Bean
    public PayConfig payConfig() {
        return new PayConfig();
    }

    @Service
    class RestemplateServiceImp implements RestemplateService, HttpMessageConverterService {

        @Autowired
        private WxPayConfig wxPayConfig;

        /**
         * @description: 获取证书路径
         **/
        @Override
        public String getCertLocalPath() {
            return wxPayConfig.getCertLocalPath();
        }

        /**
         * @description: 获取证书密码
         **/
        @Override
        public String getCertPassword() {
            return wxPayConfig.getCertPassword();
        }

        /**
         * @description: 消息转换器
         **/
        @Override
        public HttpMessageConverter getMessageConverter() {
            return new WxMappingJackson2HttpMessageConverter();
        }
    }

    public class WxMappingJackson2HttpMessageConverter extends MappingJackson2XmlHttpMessageConverter {
        public WxMappingJackson2HttpMessageConverter() {
            List<MediaType> mediaTypes = new ArrayList<>();
            mediaTypes.add(MediaType.TEXT_PLAIN);
            mediaTypes.add(MediaType.MULTIPART_FORM_DATA);
            mediaTypes.add(MediaType.APPLICATION_JSON);
            setSupportedMediaTypes(mediaTypes);
        }
    }

}
