package com.jhscale.alipay.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author lie_w
 * @title: AliPayConfig
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2019/11/710:06
 */
@Data
@ConfigurationProperties(prefix = "com.jhscale.ali")
public class AliPayConfig {

    public final static String URL = "https://openapi.alipay.com/gateway.do";

    //参数返回格式，只支持json json（固定）
    public final static String FORMAT = "json";

    //请求和签名使用的字符编码格式，支持GBK和UTF-8 开发者根据实际工程编码配置
    public final static String CHARSET = "UTF-8";

    /**
     * 服务商编号
     */
    private String sysServiceProviderId;

    /**
     * APPID
     */
    private String appId;

    /**
     * APP_PRIVATE_KEY
     */
    private String appPrivateKey;

    /**
     * ALIPAY_PUBLIC_KEY
     */
    private String aliPayPublicKey;

    /**
     * SIGN_TYPE
     */
    private String signType;

    /**
     * 回调地址
     */
    private String notifyUrl;

    /**
     * 快截版费率
     */
    private String rate;
}
