package com.jhscale.pay.req;

import com.jhscale.pay.model.BasePayReq;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lie_w
 * @title: WxCreateOrderReq
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2019/11/2322:34
 */
@Data
public class CreateOrderReq extends BasePayReq {

    @ApiModelProperty(value = "设备号", name = "mac", required = true)
    private String mac;

    @ApiModelProperty(value = "商品描述", name = "body", required = true)
    private String body;

    @ApiModelProperty(value = "商户订单号", name = "orderNo", required = true)
    private String orderNo;

    @ApiModelProperty(value = "总金额,单位为元", name = "totalFee", required = true)
    private BigDecimal totalFee;

    @ApiModelProperty(value = "终端IP", name = "ip", required = true)
    private String ip;

    @ApiModelProperty(value = "支付码", name = "payCode", required = true)
    private String payCode;

    @ApiModelProperty(value = "订单创建时间", name = "createTime", required = true)
    private Date createTime;

    @ApiModelProperty(value = "门店id", name = "storeId", required = true)
    private String storeId;

    @ApiModelProperty(value = "商户操作员编号", name = "adminId", required = true)
    private String adminId;

    @ApiModelProperty(value = "门店名称", name = "storeName")
    private String storeName;

    @ApiModelProperty(value = "门店行政区划码", name = "areaCode")
    private String areaCode;
}
