package com.jhscale.wxpay.client;

import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.model.WxPayReq;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.client.RestTemplate;

/**
 * @author lie_w
 * @title: WxPayClient
 * @projectName rely-on-pay
 * @description: TODO
 * @date 2019/11/312:56
 */
@Slf4j
public class WxPayClient {

    private RestTemplate restTemplate;

    private WxPayConfig wxPayConfig;

    public WxPayClient(WxPayConfig wxPayConfig, RestTemplate restTemplate) {
        this.wxPayConfig = wxPayConfig;
        this.restTemplate = restTemplate;
    }

    /**
     * 发起请求
     *
     * @param request 请求对象
     * @param tClass  响应对象的类型
     * @param <T>     响应对象的类型
     * @return 响应对象
     */
    public <T> T execute(WxPayReq request, Class<T> tClass) {
        request.initConfig(wxPayConfig);
        request.randomNonceStr();
        request.initSign(wxPayConfig.getKey());
        String nonceStr = request.getNonce_str();
        log.debug("id:{},post-url =>{}", nonceStr, request.getUrl(wxPayConfig.getChannel()));
        long start = System.currentTimeMillis();
        T result = (T) request.sendReq(restTemplate, wxPayConfig, tClass);
        log.info("WX: RestTemplate 耗时：{}" + (System.currentTimeMillis() - start));
        log.debug("id:{},post-res=>{}", nonceStr, result);
        return result;
    }

    /**
     * 发起请求
     *
     * @param request 请求对象
     * @param <T>     响应对象的类型
     * @return 响应对象
     */
    public <T> T execute(WxPayReq request) {
        return (T) execute(request, request.getResClass());
    }
}
