package com.jhscale.wxpay.model;

import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.*;

/**
 * Created by yuliang on 2016/11/16.
 */
public interface MapXml {

    default String toXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<xml>");
        Map<String, Object> map = new HashMap<>();
        Field[] fields = getClass().getDeclaredFields();
        for (Field field : fields) {
            Object obj;
            try {
                field.setAccessible(true);
                obj = field.get(this);
                if (obj != null) {
                    if (obj instanceof String) {
                        String str = (String) obj;
                        if (!"".equals(str)) {
                            map.put(field.getName(), obj);
                            sb.append("<").append(field.getName()).append("><![CDATA[").append(obj).append("]]></").append(field.getName()).append(">");
                        }
                    } else {
                        map.put(field.getName(), obj);
                        sb.append("<").append(field.getName()).append("><![CDATA[").append(obj).append("]]></").append(field.getName()).append(">");
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        sb.append("</xml>");
        return sb.toString();
    }


    default Map<String, Object> toMap(String... params) {
        boolean cont = false;
        List<String> paramsList = new ArrayList<>();
        if (params != null && params.length > 0) {
            cont = true;
            paramsList = Arrays.asList(params);
        }

        Map<String, Object> map = new HashMap<>();
        Field[] fields = getClass().getDeclaredFields();
        for (Field field : fields) {
            if (cont && paramsList.contains(field.getName())) continue;
            Object obj;
            try {
                field.setAccessible(true);
                obj = field.get(this);
                if (obj != null) {
                    if (obj instanceof String) {
                        String str = (String) obj;
                        if (StringUtils.isNotEmpty(str)) {
                            map.put(field.getName(), obj);
                        }
                    } else {
                        map.put(field.getName(), obj);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}
