package com.jhscale.wxpay.req;

import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ApplymentMicroSubmitGetstateRes;
import com.jhscale.wxpay.utils.XMLUtils;
import lombok.Data;

/**
 * 小微查询申请状态
 * https://pay.weixin.qq.com/wiki/doc/api/xiaowei.php?chapter=19_2
 */
@Data
public class ApplymentMicroSubmitGetstateReq implements WxPayReq<ApplymentMicroSubmitGetstateRes> {
    @Override
    public String getUrl(String channel) {
        return channel + "/applyment/micro/getstate";
    }

    /**
     * 接口版本号 [是] 默认值1.0
     */
    private String version = "1.0";

    /**
     * 商户号 [是] 服务商的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 [是] 自定义随机字符串，可参照随机数生成算法
     */
    private String nonce_str;

    /**
     * 签名类型 [是] 签名类型，仅支持HMAC-SHA256 。该字段需参与签名sign的计算。
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 签名 [是] 通过签名计算后得到的签名值，详见签名生成算法
     */
    private String sign;

    /**
     * 商户申请单号 [否] 微信支付分配的申请单号。applyment_id、business_code两者不能同时为空。
     */
    private String applyment_id;

    /**
     * 业务申请编号 [否] 服务商自定义的商户唯一编号。当applyment_id已填写时，此字段无效。
     */
    private String business_code;

    @Override
    public Class<ApplymentMicroSubmitGetstateRes> getResClass() {
        return ApplymentMicroSubmitGetstateRes.class;
    }

    @Override
    public Class getResultType(Class tClass) {
        return String.class;
    }

    @Override
    public ApplymentMicroSubmitGetstateRes getResult(Object res, WxPayConfig wxPayConfig) {
        System.out.println(res);
        return (ApplymentMicroSubmitGetstateRes) XMLUtils.convertXmlStrToObject(ApplymentMicroSubmitGetstateRes.class, (String) res);
    }
}
