package com.jhscale.wxpay.req;

import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.ApplymentMicroSubmitupgradeGetstateRes;
import lombok.Data;

/**
 * 查询升级申请单状态接口
 * https://pay.weixin.qq.com/wiki/doc/api/mch_xiaowei.php?chapter=28_3&index=3
 */
@Data
public class ApplymentMicroSubmitupgradeGetstateReq implements WxPayReq<ApplymentMicroSubmitupgradeGetstateRes> {
    @Override
    public String getUrl(String channel) {
        return channel + "/applyment/micro/getupgradestate";
    }

    /**
     * 接口版本号 [是] 默认值1.0
     */
    private String version = "1.0";

    /**
     * 商户号 [是] 服务商的商户号
     */
    private String mch_id;

    /**
     * 随机字符串 [是] 参考签名规则
     */
    private String nonce_str;

    /**
     * 签名类型 [是] 签名类型，仅支持HMAC-SHA256
     */
    private String sign_type = "HMAC-SHA256";

    /**
     * 签名 [是] 参考签名规则
     */
    private String sign;

    /**
     * 小微商户号 [是] 小微商户的商户号（小微申请状态需为待签约或完成）
     */
    private String sub_mch_id;

    @Override
    public Class<ApplymentMicroSubmitupgradeGetstateRes> getResClass() {
        return ApplymentMicroSubmitupgradeGetstateRes.class;
    }
}
