package com.jhscale.wxpay.req;

import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.DownloadBillRes;
import com.jhscale.wxpay.utils.XMLUtils;
import lombok.Data;

/**
 * 下载对账单
 * https://pay.weixin.qq.com/wiki/doc/api/wxa/wxa_api.php?chapter=9_6
 */
@Data
public class DownloadBillReq implements WxPayReq<DownloadBillRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/pay/downloadbill";
    }

    /**
     * 小程序ID [是]
     */
    private String appid;

    /**
     * 商户号 [是]
     */
    private String mch_id;

    /**
     * 子商户公众账号ID [否] 服务商下使用
     */
    private String sub_appid;

    /**
     * 子商户号 [是]  服务商下使用
     */
    private String sub_mch_id;

    /**
     * 随机字符串 [是]
     */
    private String nonce_str;

    /**
     * 签名 [是]
     */
    private String sign;

    /**
     * 对账单日期 [是]
     */
    private String bill_date;

    /**
     * 账单类型 [否]
     */
    private String bill_type;

    /**
     * 压缩账单 [否]
     */
    private String tar_type;

    @Override
    public Class<String> getResClass() {
        return String.class;
    }

    @Override
    public Class getResultType(Class downloadBillResClass) {
        return String.class;
    }

    @Override
    public DownloadBillRes getResult(Object res, WxPayConfig wxPayConfig) {
        DownloadBillRes result = new DownloadBillRes();
        if (XMLUtils.isXmlDocument((String) res)) {
            result = (DownloadBillRes) XMLUtils.convertXmlStrToObject(DownloadBillRes.class, (String) res);
        } else {
            result.setData((String) res);
            result.setReturn_code("SUCCESS");
        }
        return result;
    }
}
