package com.jhscale.wxpay.req;

import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MchModifySettlementRes;
import lombok.Data;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

/**
 * 特约商户 修改结算账户API
 * https://pay.weixin.qq.com/wiki/doc/api/mch_xiaowei.php?chapter=30_1&index=1
 */
@Data
public class MchModifySettlementReq implements WxPayReq<MchModifySettlementRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/v3/apply4sub/sub_merchants/" + this.sub_mchid + "/modify-settlement";
    }

    /**
     * 特约商户号 [是] 请填写本服务商负责进件的特约商户号
     * 示例值：1511101111
     */
    private String sub_mchid;

    /**
     * 账户类型 [是]
     * 根据特约商户号的主体类型，可选择的账户类型如下：
     * 1、小微主体：经营者个人银行卡
     * 2、个体工商户主体：经营者个人银行卡/ 对公银行账户
     * 3、企业主体：对公银行账户
     * 4、党政、机关及事业单位主体：对公银行账户
     * 5、其他组织主体：对公银行账户
     * 枚举值：
     * 对公银行账户：
     * ACCOUNT_TYPE_BUSINESS
     * 经营者个人银行卡：
     * ACCOUNT_TYPE_PRIVATE
     * 示例值:ACCOUNT_TYPE_BUSINESS
     */
    private String account_type;

    /**
     * 开户银行 [是] 请填写开户银行名称，详细参见开户银行对照表。
     * 示例值： 工商银行
     */
    private String account_bank;

    /**
     * 开户银行省市编码 [是] 需至少精确到市，详细参见省市区编号对照表
     * 示例值：110000
     */
    private String bank_address_code;

    /**
     * 开户银行全称（含支行） [否]
     * 1、若开户银行为“其他银行”，则需二选一填写“开户银行全称（含支行）”或“开户银行联行号”
     * 2、填写银行全称，如"深圳农村商业银行XXX支行" ，详细参见开户银行全称（含支行）对照表
     * 示例值： 施秉县农村信用合作联社城关信用社
     */
    private String bank_name;

    /**
     * 开户银行联行号[否]
     * 1、若开户银行为“其他银行”，则需二选一填写“开户银行全称（含支行）”或“开户银行联行号”
     * 2、填写银行联行号，详细参见开户银行全称（含支行）对照表
     * 示例值：402713354941
     */
    private String bank_branch_id;

    /**
     * 银行账号[是]
     * 1、数字，长度遵循系统支持的对公/对私卡号长度要求
     * 2、该字段需进行加密处理，加密方法详见敏感信息加密说明。
     * 3、附注：经营者个人银行卡，暂不支持以下前缀的银行卡
     * "623501；621468；620522；625191；622384；623078；940034；622150；622151；622181；622188；955100；621095；620062；621285；621798；621799；621797；622199；621096；62215049；62215050；62215051；62218849；62218850；62218851；621622；623219；621674；623218；621599；623698；623699；623686；621098；620529；622180；622182；622187；622189；621582；623676；623677；622812；622810；622811；628310；625919；625368；625367；518905；622835；625603；625605；518905"
     * 示例值：d+xT+MQCvrLHUVDWv/8MR/dB7TkXM2YYZlokmXzFsWs35NXUot7C0NcxIrUF5FnxqCJHkNgKtxa6RxEYyba1+VBRLnqKG2fSy/Y5qDN08Ej9zHCwJjq52Wg1VG8MRugli9YMI1fI83KGBxhuXyemgS/hqFKsfYGiOkJqjTUpgY5VqjtL2N4l4z11T0ECB/aSyVXUysOFGLVfSrUxMPZy6jWWYGvT1+4P633f+R+ki1gT4WF/2KxZOYmli385ZgVhcR30mr4/G3HBcxi13zp7FnEeOsLlvBmI1PHN4C7Rsu3WL8sPndjXTd75kPkyjqnoMRrEEaYQE8ZRGYoeorwC+w==
     * 请求示例
     */
    private String account_number;

    /**
     * 随机字符串 [否] 配合结构使用
     */
    private String nonce_str;

    @Override
    public void setSign(String sign) {

    }

    @Override
    public void randomNonceStr() {

    }

    @Override
    public Class getResultType(Class tClass) {
        return String.class;
    }

    @Override
    public Object sendReq(RestTemplate restTemplate, WxPayConfig wxPayConfig, Class tClass) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<MchModifySettlementReq> entity = new HttpEntity(this, headers);
        return restTemplate.postForObject(getUrl(wxPayConfig.getChannel()), entity, getResultType(tClass));
    }

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return MchModifySettlementReq.class;
    }
}
