package com.jhscale.wxpay.req;

import com.jhscale.wxpay.config.WxPayConfig;
import com.jhscale.wxpay.model.WxPayReq;
import com.jhscale.wxpay.res.MchSettlementRes;
import lombok.Data;
import org.springframework.web.client.RestTemplate;

/**
 * 特约商户 查询结算账户API
 * https://pay.weixin.qq.com/wiki/doc/api/mch_xiaowei.php?chapter=30_2&index=2
 */
@Data
public class MchSettlementReq implements WxPayReq<MchSettlementRes> {

    @Override
    public String getUrl(String channel) {
        return channel + "/v3/apply4sub/sub_merchants/" + this.sub_mchid + "/settlement";
    }

    /**
     * 特约商户号 [是] 请输入本服务商进件、已签约的特约商户号
     * 特殊规则：字符最小长度为8
     * 示例值：1900006491
     */
    private String sub_mchid;

    /**
     * 随机字符串 [否] 配合结构使用
     */
    private String nonce_str;

    @Override
    public void setSign(String sign) {

    }

    @Override
    public void randomNonceStr() {

    }

    @Override
    public Object sendReq(RestTemplate restTemplate, WxPayConfig wxPayConfig, Class tClass) {
        return restTemplate.getForObject(getUrl(wxPayConfig.getChannel()), getResultType(tClass));
    }

    /**
     * 返回值类型
     *
     * @return
     */
    @Override
    public Class getResClass() {
        return MchSettlementRes.class;
    }
}
